/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.annotations.AsParameterConverter;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Steps;

public abstract class AbstractStepsFactory
implements InjectableStepsFactory {
    private final Configuration configuration;

    public AbstractStepsFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public List<CandidateSteps> createCandidateSteps() {
        List<Class<?>> types = this.stepsTypes();
        ArrayList<CandidateSteps> steps = new ArrayList<CandidateSteps>();
        for (Class<?> type : types) {
            this.configuration.parameterConverters().addConverters(this.methodReturningConverters(type));
            steps.add(new Steps(this.configuration, type, this));
        }
        return steps;
    }

    protected abstract List<Class<?>> stepsTypes();

    private List<ParameterConverters.ParameterConverter> methodReturningConverters(Class<?> type) {
        ArrayList<ParameterConverters.ParameterConverter> converters = new ArrayList<ParameterConverters.ParameterConverter>();
        for (Method method : type.getMethods()) {
            if (!method.isAnnotationPresent(AsParameterConverter.class)) continue;
            converters.add(new ParameterConverters.MethodReturningConverter(method, type, this));
        }
        return converters;
    }

    protected boolean hasAnnotatedMethods(Type type) {
        if (type instanceof Class) {
            for (Method method : ((Class)type).getMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    if (!annotation.annotationType().getName().startsWith("org.jbehave.core.annotations")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class StepsInstanceNotFound
    extends RuntimeException {
        public StepsInstanceNotFound(Class<?> type, InjectableStepsFactory stepsFactory) {
            super("Steps instance not found for type " + type + " in factory " + stepsFactory);
        }
    }
}

