/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.parsers.RegexStepMatcher;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.parsers.StepPatternParser;
import org.jbehave.core.steps.StepType;

public class RegexPrefixCapturingPatternParser
implements StepPatternParser {
    private static final String DEFAULT_PREFIX = "$";
    private static final String DEFAULT_CHARACTER_CLASS = "[\\p{L}\\p{N}\\p{Pc}]";
    private final String prefix;
    private final String characterClass;

    public RegexPrefixCapturingPatternParser() {
        this(DEFAULT_PREFIX);
    }

    public RegexPrefixCapturingPatternParser(String prefix) {
        this(prefix, DEFAULT_CHARACTER_CLASS);
    }

    public RegexPrefixCapturingPatternParser(String prefix, String characterClass) {
        this.prefix = prefix;
        this.characterClass = characterClass;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public StepMatcher parseStep(StepType stepType, String stepPattern) {
        String escapingPunctuation = this.escapingPunctuation(stepPattern);
        List<Parameter> parameters = this.findParameters(escapingPunctuation);
        Pattern regexPattern = this.buildPattern(escapingPunctuation, parameters);
        return new RegexStepMatcher(stepType, escapingPunctuation, regexPattern, this.parameterNames(parameters));
    }

    private Pattern buildPattern(String stepPattern, List<Parameter> parameters) {
        return Pattern.compile(this.parameterCapturingRegex(stepPattern, parameters), 32);
    }

    private String[] parameterNames(List<Parameter> parameters) {
        ArrayList<String> names = new ArrayList<String>();
        for (Parameter parameter : parameters) {
            names.add(parameter.name);
        }
        return names.toArray(new String[names.size()]);
    }

    private List<Parameter> findParameters(String pattern) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Matcher findingAllParameterNames = this.findingAllParameterNames().matcher(pattern);
        while (findingAllParameterNames.find()) {
            parameters.add(new Parameter(pattern, findingAllParameterNames.start(), findingAllParameterNames.end(), findingAllParameterNames.group(2)));
        }
        return parameters;
    }

    private Pattern findingAllParameterNames() {
        return Pattern.compile("(\\" + this.prefix + this.characterClass + "*)(\\W|\\Z)", 32);
    }

    private String escapingPunctuation(String pattern) {
        return pattern.replaceAll("([\\[\\]\\{\\}\\?\\^\\.\\*\\(\\)\\+\\\\])", "\\\\$1");
    }

    private String ignoringWhitespace(String pattern) {
        return pattern.replaceAll("\\s+", "\\\\s+");
    }

    private String parameterCapturingRegex(String stepPattern, List<Parameter> parameters) {
        String regex = stepPattern;
        String capture = "(.*)";
        for (int i = parameters.size(); i > 0; --i) {
            Parameter parameter = parameters.get(i - 1);
            String start = regex.substring(0, parameter.start);
            String end = regex.substring(parameter.end);
            String whitespaceIfAny = parameter.whitespaceIfAny;
            regex = start + capture + whitespaceIfAny + end;
        }
        return this.ignoringWhitespace(regex);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private class Parameter {
        private final int start;
        private final int end;
        private final String whitespaceIfAny;
        private final String name;

        public Parameter(String pattern, int start, int end, String whitespaceIfAny) {
            this.start = start;
            this.end = end;
            this.whitespaceIfAny = whitespaceIfAny;
            this.name = pattern.substring(start + RegexPrefixCapturingPatternParser.this.prefix.length(), end - whitespaceIfAny.length()).trim();
        }

        public String toString() {
            return this.name;
        }
    }
}

