/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jbehave.core.Embeddable;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;

public abstract class ConfigurableEmbedder
implements Embeddable {
    private Embedder embedder = new Embedder();
    private Configuration configuration;
    private InjectableStepsFactory stepsFactory;
    private List<CandidateSteps> candidateSteps;

    @Override
    public void useEmbedder(Embedder embedder) {
        this.embedder = embedder;
    }

    public void useConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public void addSteps(CandidateSteps ... steps) {
        this.addSteps(Arrays.asList(steps));
    }

    public void addSteps(List<CandidateSteps> steps) {
        if (this.candidateSteps == null) {
            this.candidateSteps = new ArrayList<CandidateSteps>();
        }
        this.candidateSteps.addAll(steps);
    }

    public List<CandidateSteps> candidateSteps() {
        return this.candidateSteps;
    }

    public void useStepsFactory(InjectableStepsFactory stepsFactory) {
        this.stepsFactory = stepsFactory;
    }

    public InjectableStepsFactory stepsFactory() {
        return this.stepsFactory;
    }

    public boolean hasStepsFactory() {
        return this.stepsFactory != null;
    }

    public Embedder configuredEmbedder() {
        if (this.configuration == null) {
            this.configuration = this.configuration();
        }
        this.embedder.useConfiguration(this.configuration);
        if (this.candidateSteps == null) {
            this.candidateSteps = this.candidateSteps();
        }
        this.embedder.useCandidateSteps(this.candidateSteps);
        if (this.stepsFactory == null) {
            this.stepsFactory = this.stepsFactory();
        }
        this.embedder.useStepsFactory(this.stepsFactory);
        return this.embedder;
    }
}

