/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.annotations.Scope;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.embedder.FilteredStory;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.failures.FailureStrategy;
import org.jbehave.core.failures.PendingStepFound;
import org.jbehave.core.failures.PendingStepStrategy;
import org.jbehave.core.failures.RestartingScenarioFailure;
import org.jbehave.core.failures.RestartingStoryFailure;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.GivenStory;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.ConcurrentStoryReporter;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.PendingStepMethodGenerator;
import org.jbehave.core.steps.ProvidedStepsFactory;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepResult;

public class StoryRunner {
    private ThreadLocal<FailureStrategy> currentStrategy = new ThreadLocal();
    private ThreadLocal<FailureStrategy> failureStrategy = new ThreadLocal();
    private ThreadLocal<PendingStepStrategy> pendingStepStrategy = new ThreadLocal();
    private ThreadLocal<UUIDExceptionWrapper> storyFailure = new ThreadLocal();
    private ThreadLocal<StoryReporter> reporter = new ThreadLocal();
    private ThreadLocal<String> reporterStoryPath = new ThreadLocal();
    private ThreadLocal<State> storiesState = new ThreadLocal();
    private Map<Story, StoryDuration> cancelledStories = new HashMap<Story, StoryDuration>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State runBeforeOrAfterStories(Configuration configuration, List<CandidateSteps> candidateSteps, StepCollector.Stage stage) {
        String storyPath = StringUtils.capitalizeFirstLetter((String)stage.name().toLowerCase()) + "Stories";
        this.reporter.set(configuration.storyReporter(storyPath));
        this.reporter.get().beforeStory(new Story(storyPath), false);
        RunContext context = new RunContext(configuration, candidateSteps, storyPath, MetaFilter.EMPTY);
        if (stage == StepCollector.Stage.BEFORE) {
            this.resetStoryFailure(context);
        }
        if (stage == StepCollector.Stage.AFTER && this.storiesState.get() != null) {
            context.stateIs(this.storiesState.get());
        }
        try {
            this.runStepsWhileKeepingState(context, configuration.stepCollector().collectBeforeOrAfterStoriesSteps(context.candidateSteps(), stage));
        }
        catch (InterruptedException e) {
            throw new UUIDExceptionWrapper(e);
        }
        this.reporter.get().afterStory(false);
        this.storiesState.set(context.state());
        if (stage == StepCollector.Stage.BEFORE && this.reporter.get() instanceof ConcurrentStoryReporter) {
            ((ConcurrentStoryReporter)this.reporter.get()).invokeDelayed();
        }
        if (stage == StepCollector.Stage.AFTER) {
            try {
                this.handleStoryFailureByStrategy();
            }
            catch (Throwable e) {
                SomethingHappened somethingHappened = new SomethingHappened(this.storyFailure.get());
                return somethingHappened;
            }
            finally {
                if (this.reporter.get() instanceof ConcurrentStoryReporter) {
                    ((ConcurrentStoryReporter)this.reporter.get()).invokeDelayed();
                }
            }
        }
        return context.state();
    }

    public void run(Configuration configuration, List<CandidateSteps> candidateSteps, Story story) throws Throwable {
        this.run(configuration, candidateSteps, story, MetaFilter.EMPTY);
    }

    public void run(Configuration configuration, List<CandidateSteps> candidateSteps, Story story, MetaFilter filter) throws Throwable {
        this.run(configuration, candidateSteps, story, filter, null);
    }

    public void run(Configuration configuration, List<CandidateSteps> candidateSteps, Story story, MetaFilter filter, State beforeStories) throws Throwable {
        this.run(configuration, new ProvidedStepsFactory(candidateSteps), story, filter, beforeStories);
    }

    public void run(Configuration configuration, InjectableStepsFactory stepsFactory, Story story, MetaFilter filter, State beforeStories) throws Throwable {
        RunContext context = new RunContext(configuration, stepsFactory, story.getPath(), filter);
        if (beforeStories != null) {
            context.stateIs(beforeStories);
        }
        HashMap<String, String> storyParameters = new HashMap<String, String>();
        this.run(context, story, storyParameters);
    }

    public Story storyOfPath(Configuration configuration, String storyPath) {
        String storyAsText = configuration.storyLoader().loadStoryAsText(storyPath);
        return configuration.storyParser().parseStory(storyAsText, storyPath);
    }

    public Story storyOfText(Configuration configuration, String storyAsText, String storyId) {
        return configuration.storyParser().parseStory(storyAsText, storyId);
    }

    public void cancelStory(Story story, StoryDuration storyDuration) {
        this.cancelledStories.put(story, storyDuration);
    }

    private boolean restartStory(Throwable cause) {
        while (cause != null) {
            if (cause instanceof RestartingStoryFailure) {
                return true;
            }
            cause = cause.getCause();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(RunContext context, Story story, Map<String, String> storyParameters) throws Throwable {
        block8: {
            boolean restartingStory = false;
            try {
                this.runCancellable(context, story, storyParameters);
            }
            catch (Throwable e) {
                if (this.cancelledStories.containsKey(story)) {
                    this.reporter.get().storyCancelled(story, this.cancelledStories.get(story));
                    this.reporter.get().afterScenario();
                    this.reporter.get().afterStory(context.givenStory);
                }
                if (this.restartStory(e)) {
                    this.reporter.get().restartedStory(story, e);
                    restartingStory = true;
                    this.run(context, story, storyParameters);
                    break block8;
                }
                throw e;
            }
            finally {
                if (!context.givenStory() && this.reporter.get() instanceof ConcurrentStoryReporter && !restartingStory) {
                    ((ConcurrentStoryReporter)this.reporter.get()).invokeDelayed();
                }
            }
        }
    }

    private void runCancellable(RunContext context, Story story, Map<String, String> storyParameters) throws Throwable {
        if (!context.givenStory()) {
            this.reporter.set(this.reporterFor(context, story));
        }
        this.pendingStepStrategy.set(context.configuration().pendingStepStrategy());
        this.failureStrategy.set(context.configuration().failureStrategy());
        this.resetStoryFailure(context);
        if (context.dryRun()) {
            this.reporter.get().dryRun();
        }
        if (context.configuration().storyControls().resetStateBeforeStory()) {
            context.resetState();
        }
        this.reporter.get().beforeStory(story, context.givenStory());
        boolean storyAllowed = true;
        FilteredStory filterContext = context.filter(story);
        Meta storyMeta = story.getMeta();
        if (!filterContext.allowed()) {
            this.reporter.get().storyNotAllowed(story, context.metaFilterAsString());
            storyAllowed = false;
        }
        if (storyAllowed) {
            this.reporter.get().narrative(story.getNarrative());
            this.runBeforeOrAfterStorySteps(context, story, StepCollector.Stage.BEFORE);
            this.addMetaParameters(storyParameters, storyMeta);
            this.runGivenStories(story.getGivenStories(), storyParameters, context);
            boolean runBeforeAndAfterScenarioSteps = this.shouldRunBeforeOrAfterScenarioSteps(context);
            this.reporter.get().lifecyle(story.getLifecycle());
            for (Scenario scenario : story.getScenarios()) {
                boolean scenarioAllowed = true;
                if (this.failureOccurred(context) && context.configuration().storyControls().skipScenariosAfterFailure()) continue;
                this.reporter.get().beforeScenario(scenario);
                this.reporter.get().beforeScenario(scenario.getTitle());
                this.reporter.get().scenarioMeta(scenario.getMeta());
                if (!filterContext.allowed(scenario)) {
                    this.reporter.get().scenarioNotAllowed(scenario, context.metaFilterAsString());
                    scenarioAllowed = false;
                }
                if (scenarioAllowed) {
                    if (context.configuration().storyControls().resetStateBeforeScenario()) {
                        context.resetState();
                    }
                    Meta storyAndScenarioMeta = scenario.getMeta().inheritFrom(storyMeta);
                    if (runBeforeAndAfterScenarioSteps) {
                        this.runBeforeOrAfterScenarioSteps(context, scenario, storyAndScenarioMeta, StepCollector.Stage.BEFORE, ScenarioType.NORMAL);
                    }
                    if (this.isParameterisedByExamples(scenario)) {
                        this.runScenariosParametrisedByExamples(context, scenario, story.getLifecycle(), storyAndScenarioMeta);
                    } else {
                        this.runStepsWithLifecycle(context, story.getLifecycle(), storyParameters, scenario, storyAndScenarioMeta);
                    }
                    if (runBeforeAndAfterScenarioSteps) {
                        this.runBeforeOrAfterScenarioSteps(context, scenario, storyAndScenarioMeta, StepCollector.Stage.AFTER, ScenarioType.NORMAL);
                    }
                }
                this.reporter.get().afterScenario();
            }
            this.runBeforeOrAfterStorySteps(context, story, StepCollector.Stage.AFTER);
        }
        this.reporter.get().afterStory(context.givenStory());
        if (!context.givenStory()) {
            this.handleStoryFailureByStrategy();
        }
    }

    private void addMetaParameters(Map<String, String> storyParameters, Meta meta) {
        for (String name : meta.getPropertyNames()) {
            storyParameters.put(name, meta.getProperty(name));
        }
    }

    private boolean shouldRunBeforeOrAfterScenarioSteps(RunContext context) {
        Configuration configuration = context.configuration();
        if (!configuration.storyControls().skipBeforeAndAfterScenarioStepsIfGivenStory()) {
            return true;
        }
        return !context.givenStory();
    }

    private boolean failureOccurred(RunContext context) {
        return context.failureOccurred();
    }

    private StoryReporter reporterFor(RunContext context, Story story) {
        Configuration configuration = context.configuration();
        if (context.givenStory()) {
            return configuration.storyReporter(this.reporterStoryPath.get());
        }
        this.reporterStoryPath.set(story.getPath());
        return configuration.storyReporter(this.reporterStoryPath.get());
    }

    private void handleStoryFailureByStrategy() throws Throwable {
        Throwable throwable = this.storyFailure.get();
        if (throwable != null) {
            this.currentStrategy.get().handleFailure(throwable);
        }
    }

    private void resetStoryFailure(RunContext context) {
        if (context.givenStory()) {
            return;
        }
        this.currentStrategy.set(context.configuration().failureStrategy());
        this.storyFailure.set(null);
    }

    private void runGivenStories(GivenStories givenStories, Map<String, String> parameters, RunContext context) throws Throwable {
        if (givenStories.getPaths().size() > 0) {
            this.reporter.get().givenStories(givenStories);
            for (GivenStory givenStory : givenStories.getStories()) {
                RunContext childContext = context.childContextFor(givenStory);
                Story story = this.storyOfPath(context.configuration(), childContext.path());
                if (givenStory.hasAnchorParameters()) {
                    story = this.storyWithMatchingScenarios(story, givenStory.getAnchorParameters());
                }
                parameters.putAll(givenStory.getParameters());
                this.run(childContext, story, parameters);
            }
        }
    }

    private Story storyWithMatchingScenarios(Story story, Map<String, String> parameters) {
        if (parameters.isEmpty()) {
            return story;
        }
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        for (Scenario scenario : story.getScenarios()) {
            if (!this.matchesParameters(scenario, parameters)) continue;
            scenarios.add(scenario);
        }
        return new Story(story.getPath(), story.getDescription(), story.getMeta(), story.getNarrative(), scenarios);
    }

    private boolean matchesParameters(Scenario scenario, Map<String, String> parameters) {
        Meta meta = scenario.getMeta();
        for (String name : parameters.keySet()) {
            if (!meta.hasProperty(name)) continue;
            return meta.getProperty(name).equals(parameters.get(name));
        }
        return false;
    }

    private boolean isParameterisedByExamples(Scenario scenario) {
        return scenario.getExamplesTable().getRowCount() > 0 && !scenario.getGivenStories().requireParameters();
    }

    private void runScenariosParametrisedByExamples(RunContext context, Scenario scenario, Lifecycle lifecycle, Meta storyAndScenarioMeta) throws Throwable {
        ExamplesTable table = scenario.getExamplesTable();
        this.reporter.get().beforeExamples(scenario.getSteps(), table);
        Keywords keywords = context.configuration().keywords();
        for (Map<String, String> scenarioParameters : table.getRows()) {
            Meta parameterMeta = this.parameterMeta(keywords, scenarioParameters);
            if (!parameterMeta.isEmpty() && !context.filter.allow(parameterMeta)) continue;
            this.reporter.get().example(scenarioParameters);
            if (context.configuration().storyControls().resetStateBeforeScenario()) {
                context.resetState();
            }
            this.runBeforeOrAfterScenarioSteps(context, scenario, storyAndScenarioMeta, StepCollector.Stage.BEFORE, ScenarioType.EXAMPLE);
            this.runStepsWithLifecycle(context, lifecycle, scenarioParameters, scenario, storyAndScenarioMeta);
            this.runBeforeOrAfterScenarioSteps(context, scenario, storyAndScenarioMeta, StepCollector.Stage.AFTER, ScenarioType.EXAMPLE);
        }
        this.reporter.get().afterExamples();
    }

    private void runStepsWithLifecycle(RunContext context, Lifecycle lifecycle, Map<String, String> parameters, Scenario scenario, Meta storyAndScenarioMeta) throws Throwable {
        this.runBeforeOrAfterScenarioSteps(context, scenario, storyAndScenarioMeta, StepCollector.Stage.BEFORE, ScenarioType.ANY);
        this.runLifecycleSteps(context, lifecycle, StepCollector.Stage.BEFORE, storyAndScenarioMeta);
        this.addMetaParameters(parameters, storyAndScenarioMeta);
        this.runGivenStories(scenario.getGivenStories(), parameters, context);
        this.runScenarioSteps(context, scenario, parameters);
        this.runLifecycleSteps(context, lifecycle, StepCollector.Stage.AFTER, storyAndScenarioMeta);
        this.runBeforeOrAfterScenarioSteps(context, scenario, storyAndScenarioMeta, StepCollector.Stage.AFTER, ScenarioType.ANY);
    }

    private Meta parameterMeta(Keywords keywords, Map<String, String> scenarioParameters) {
        String meta = keywords.meta();
        if (scenarioParameters.containsKey(meta)) {
            return Meta.createMeta(scenarioParameters.get(meta), keywords);
        }
        return Meta.EMPTY;
    }

    private void runBeforeOrAfterStorySteps(RunContext context, Story story, StepCollector.Stage stage) throws InterruptedException {
        this.runStepsWhileKeepingState(context, context.collectBeforeOrAfterStorySteps(story, stage));
    }

    private void runBeforeOrAfterScenarioSteps(RunContext context, Scenario scenario, Meta storyAndScenarioMeta, StepCollector.Stage stage, ScenarioType type) throws InterruptedException {
        this.runStepsWhileKeepingState(context, context.collectBeforeOrAfterScenarioSteps(storyAndScenarioMeta, stage, type));
    }

    private void runLifecycleSteps(RunContext context, Lifecycle lifecycle, StepCollector.Stage stage, Meta storyAndScenarioMeta) throws InterruptedException {
        this.runStepsWhileKeepingState(context, context.collectLifecycleSteps(lifecycle, storyAndScenarioMeta, stage));
    }

    private void runScenarioSteps(RunContext context, Scenario scenario, Map<String, String> scenarioParameters) throws InterruptedException {
        boolean restart = true;
        while (restart) {
            restart = false;
            List<Step> steps = context.collectScenarioSteps(scenario, scenarioParameters);
            try {
                this.runStepsWhileKeepingState(context, steps);
            }
            catch (RestartingScenarioFailure e) {
                restart = true;
                continue;
            }
            this.generatePendingStepMethods(context, steps);
        }
    }

    private void generatePendingStepMethods(RunContext context, List<Step> steps) {
        ArrayList<StepCreator.PendingStep> pendingSteps = new ArrayList<StepCreator.PendingStep>();
        for (Step step : steps) {
            if (!(step instanceof StepCreator.PendingStep)) continue;
            pendingSteps.add((StepCreator.PendingStep)step);
        }
        if (!pendingSteps.isEmpty()) {
            PendingStepMethodGenerator generator = new PendingStepMethodGenerator(context.configuration().keywords());
            ArrayList<String> methods = new ArrayList<String>();
            for (StepCreator.PendingStep pendingStep : pendingSteps) {
                if (pendingStep.annotated()) continue;
                methods.add(generator.generateMethod(pendingStep));
            }
            this.reporter.get().pendingMethods(methods);
        }
    }

    private void runStepsWhileKeepingState(RunContext context, List<Step> steps) throws InterruptedException {
        if (steps == null || steps.size() == 0) {
            return;
        }
        State state = context.state();
        for (Step step : steps) {
            try {
                context.interruptIfCancelled();
                state = state.run(step);
            }
            catch (RestartingScenarioFailure e) {
                this.reporter.get().restarted(step.toString(), e);
                throw e;
            }
        }
        context.stateIs(state);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean failed(State state) {
        return !state.getClass().equals(FineSoFar.class);
    }

    public Throwable failure(State state) {
        if (this.failed(state)) {
            return ((SomethingHappened)state).failure.getCause();
        }
        return null;
    }

    private class RunContext {
        private final Configuration configuration;
        private final List<CandidateSteps> candidateSteps;
        private final String path;
        private final MetaFilter filter;
        private final boolean givenStory;
        private State state;
        private RunContext parentContext;

        public RunContext(Configuration configuration, InjectableStepsFactory stepsFactory, String path, MetaFilter filter) {
            this(configuration, stepsFactory.createCandidateSteps(), path, filter);
        }

        public RunContext(Configuration configuration, List<CandidateSteps> steps, String path, MetaFilter filter) {
            this(configuration, steps, path, filter, false, null);
        }

        private RunContext(Configuration configuration, List<CandidateSteps> steps, String path, MetaFilter filter, boolean givenStory, RunContext parentContext) {
            this.configuration = configuration;
            this.candidateSteps = steps;
            this.path = path;
            this.filter = filter;
            this.givenStory = givenStory;
            this.parentContext = parentContext;
            this.resetState();
        }

        public void interruptIfCancelled() throws InterruptedException {
            for (Story story : StoryRunner.this.cancelledStories.keySet()) {
                if (!this.path.equals(story.getPath())) continue;
                throw new InterruptedException(this.path);
            }
        }

        public boolean dryRun() {
            return this.configuration.storyControls().dryRun();
        }

        public Configuration configuration() {
            return this.configuration;
        }

        public List<CandidateSteps> candidateSteps() {
            return this.candidateSteps;
        }

        public boolean givenStory() {
            return this.givenStory;
        }

        public String path() {
            return this.path;
        }

        public FilteredStory filter(Story story) {
            return new FilteredStory(this.filter, story, this.configuration.storyControls(), this.givenStory);
        }

        public String metaFilterAsString() {
            return this.filter.asString();
        }

        public List<Step> collectBeforeOrAfterStorySteps(Story story, StepCollector.Stage stage) {
            return this.configuration.stepCollector().collectBeforeOrAfterStorySteps(this.candidateSteps, story, stage, this.givenStory);
        }

        public List<Step> collectBeforeOrAfterScenarioSteps(Meta storyAndScenarioMeta, StepCollector.Stage stage, ScenarioType type) {
            return this.configuration.stepCollector().collectBeforeOrAfterScenarioSteps(this.candidateSteps, storyAndScenarioMeta, stage, type);
        }

        public List<Step> collectLifecycleSteps(Lifecycle lifecycle, Meta storyAndScenarioMeta, StepCollector.Stage stage) {
            return this.configuration.stepCollector().collectLifecycleSteps(this.candidateSteps, lifecycle, storyAndScenarioMeta, stage, Scope.SCENARIO);
        }

        public List<Step> collectScenarioSteps(Scenario scenario, Map<String, String> parameters) {
            return this.configuration.stepCollector().collectScenarioSteps(this.candidateSteps, scenario, parameters);
        }

        public RunContext childContextFor(GivenStory givenStory) {
            String actualPath = this.configuration.pathCalculator().calculate(this.path, givenStory.getPath());
            return new RunContext(this.configuration, this.candidateSteps, actualPath, this.filter, true, this);
        }

        public State state() {
            return this.state;
        }

        public void stateIs(State state) {
            this.state = state;
            if (this.parentContext != null) {
                this.parentContext.stateIs(state);
            }
        }

        public boolean failureOccurred() {
            return StoryRunner.this.failed(this.state);
        }

        public void resetState() {
            this.state = new FineSoFar();
        }
    }

    private final class SomethingHappened
    implements State {
        UUIDExceptionWrapper failure;

        public SomethingHappened(UUIDExceptionWrapper failure) {
            this.failure = failure;
        }

        @Override
        public State run(Step step) {
            StepResult result = step.doNotPerform(this.failure);
            result.describeTo((StoryReporter)StoryRunner.this.reporter.get());
            return this;
        }
    }

    private final class FineSoFar
    implements State {
        private FineSoFar() {
        }

        @Override
        public State run(Step step) {
            if (step instanceof StepCreator.ParametrisedStep) {
                ((StepCreator.ParametrisedStep)step).describeTo((StoryReporter)StoryRunner.this.reporter.get());
            }
            UUIDExceptionWrapper storyFailureIfItHappened = (UUIDExceptionWrapper)StoryRunner.this.storyFailure.get();
            StepResult result = step.perform(storyFailureIfItHappened);
            result.describeTo((StoryReporter)StoryRunner.this.reporter.get());
            UUIDExceptionWrapper stepFailure = result.getFailure();
            if (stepFailure == null) {
                return this;
            }
            StoryRunner.this.storyFailure.set(this.mostImportantOf(storyFailureIfItHappened, stepFailure));
            StoryRunner.this.currentStrategy.set(this.strategyFor((Throwable)StoryRunner.this.storyFailure.get()));
            return new SomethingHappened(stepFailure);
        }

        private UUIDExceptionWrapper mostImportantOf(UUIDExceptionWrapper failure1, UUIDExceptionWrapper failure2) {
            return failure1 == null ? failure2 : (failure1.getCause() instanceof PendingStepFound ? (failure2 == null ? failure1 : failure2) : failure1);
        }

        private FailureStrategy strategyFor(Throwable failure) {
            if (failure instanceof PendingStepFound) {
                return (FailureStrategy)StoryRunner.this.pendingStepStrategy.get();
            }
            return (FailureStrategy)StoryRunner.this.failureStrategy.get();
        }
    }

    public static interface State {
        public State run(Step var1);
    }
}

