/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.auditable.aspect;

import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.javers.common.collections.Maps;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.Javers;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.spring.annotation.JaversAuditableDelete;
import org.javers.spring.auditable.AspectUtil;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;

public class JaversCommitAdvice {
    private final Javers javers;
    private final AuthorProvider authorProvider;
    private final CommitPropertiesProvider commitPropertiesProvider;

    public JaversCommitAdvice(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        this.javers = javers;
        this.authorProvider = authorProvider;
        this.commitPropertiesProvider = commitPropertiesProvider;
    }

    public void commitSaveMethodArguments(JoinPoint pjp) {
        for (Object arg : AspectUtil.collectArguments(pjp)) {
            this.commitObject(arg);
        }
    }

    public void commitDeleteMethodArguments(JoinPoint jp) {
        for (Object arg : AspectUtil.collectArguments(jp)) {
            JaversType javersType = this.javers.getTypeMapping(arg.getClass());
            if (javersType instanceof ManagedType) {
                this.commitShallowDelete(arg);
                continue;
            }
            if (!(javersType instanceof PrimitiveOrValueType)) continue;
            this.commitShallowDeleteById(arg, this.getDomainTypeToDelete(jp, arg));
        }
    }

    private Class<?> getDomainTypeToDelete(JoinPoint jp, Object id) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        JaversAuditableDelete javersAuditableDelete = method.getAnnotation(JaversAuditableDelete.class);
        Class<?> entity = javersAuditableDelete.entity();
        if (entity == Void.class) {
            throw new JaversException(JaversExceptionCode.WRONG_USAGE_OF_JAVERS_AUDITABLE_DELETE, new Object[]{id, method});
        }
        return entity;
    }

    public void commitObject(Object domainObject) {
        String author = this.authorProvider.provide();
        this.javers.commit(author, domainObject, Maps.merge(this.commitPropertiesProvider.provideForCommittedObject(domainObject), this.commitPropertiesProvider.provide()));
    }

    public void commitShallowDelete(Object domainObject) {
        String author = this.authorProvider.provide();
        this.javers.commitShallowDelete(author, domainObject, Maps.merge(this.commitPropertiesProvider.provideForDeletedObject(domainObject), this.commitPropertiesProvider.provide()));
    }

    public void commitShallowDeleteById(Object domainObjectId, Class<?> domainType) {
        String author = this.authorProvider.provide();
        this.javers.commitShallowDeleteById(author, (GlobalIdDTO)InstanceIdDTO.instanceId((Object)domainObjectId, domainType), Maps.merge(this.commitPropertiesProvider.provideForDeleteById(domainType, domainObjectId), this.commitPropertiesProvider.provide()));
    }
}

