/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.auditable.aspect.springdata;

import java.util.Map;
import org.javers.core.Javers;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;
import org.javers.spring.auditable.aspect.springdata.AbstractAuditChangeHandler;
import org.springframework.data.repository.core.RepositoryMetadata;

class OnDeleteAuditChangeHandler
extends AbstractAuditChangeHandler {
    OnDeleteAuditChangeHandler(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        super(javers, authorProvider, commitPropertiesProvider);
    }

    @Override
    public void handle(RepositoryMetadata repositoryMetadata, Object domainObject) {
        Map<String, String> props = this.commitPropertiesProvider.provide();
        String author = this.authorProvider.provide();
        if (this.isIdClass(repositoryMetadata, domainObject)) {
            this.javers.commitShallowDeleteById(author, (GlobalIdDTO)InstanceIdDTO.instanceId((Object)domainObject, (Class)repositoryMetadata.getDomainType()), props);
        } else if (this.isDomainClass(repositoryMetadata, domainObject)) {
            this.javers.commitShallowDelete(author, domainObject, props);
        } else {
            throw new IllegalArgumentException("Domain object or object id expected");
        }
    }
}

