/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.aspect;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.javers.core.Javers;

public class JaversCommitAdvice
implements MethodInterceptor {
    private final Javers javers;
    private final String author;

    public JaversCommitAdvice(Javers javers, String author) {
        this.javers = javers;
        this.author = author;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object retVal = invocation.proceed();
        for (Object arg : invocation.getArguments()) {
            if (arg instanceof Iterable) {
                this.commitAllEntities((Iterable)arg);
                continue;
            }
            this.javers.commit(this.author, arg);
        }
        return retVal;
    }

    private void commitAllEntities(Iterable iterable) {
        for (Object entity : iterable) {
            this.javers.commit(this.author, entity);
        }
    }
}

