/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.boot.sql;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.repository.sql.DialectName;

public class DialectMapper {
    public DialectName map(Dialect hibernateDialect) {
        if (hibernateDialect instanceof SQLServerDialect) {
            return DialectName.MSSQL;
        }
        if (hibernateDialect instanceof H2Dialect) {
            return DialectName.H2;
        }
        if (hibernateDialect instanceof OracleDialect) {
            return DialectName.ORACLE;
        }
        if (hibernateDialect instanceof PostgreSQLDialect) {
            return DialectName.POSTGRES;
        }
        if (hibernateDialect instanceof MySQLDialect) {
            return DialectName.MYSQL;
        }
        throw new JaversException(JaversExceptionCode.UNSUPPORTED_SQL_DIALECT, new Object[]{hibernateDialect.getClass().getSimpleName()});
    }
}

