/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.boot.sql;

import org.hibernate.dialect.DB2400Dialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.repository.sql.DialectName;

public class DialectMapper {
    public DialectName map(Dialect hibernateDialect) {
        if (hibernateDialect instanceof SQLServerDialect) {
            return DialectName.MSSQL;
        }
        if (hibernateDialect instanceof H2Dialect) {
            return DialectName.H2;
        }
        if (hibernateDialect instanceof Oracle8iDialect) {
            return DialectName.ORACLE;
        }
        if (hibernateDialect instanceof PostgreSQL81Dialect) {
            return DialectName.POSTGRES;
        }
        if (hibernateDialect instanceof MySQLDialect) {
            return DialectName.MYSQL;
        }
        if (hibernateDialect instanceof DB2400Dialect) {
            return DialectName.DB2400;
        }
        if (hibernateDialect instanceof DB2Dialect) {
            return DialectName.DB2;
        }
        throw new JaversException(JaversExceptionCode.UNSUPPORTED_SQL_DIALECT, new Object[]{hibernateDialect.getClass().getSimpleName()});
    }
}

