/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.boot.sql;

import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.MappingStyle;
import org.javers.core.diff.ListCompareAlgorithm;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.sql.ConnectionProvider;
import org.javers.repository.sql.DialectName;
import org.javers.repository.sql.JaversSqlRepository;
import org.javers.repository.sql.SqlRepositoryBuilder;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.aspect.JaversAuditableRepositoryAspect;
import org.javers.spring.boot.sql.JaversProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={JaversProperties.class})
public class JaversSqlAutoConfiguration {
    @Autowired
    private JaversProperties javersProperties;
    @Autowired
    private ConnectionProvider connectionProvider;

    @Bean
    public Javers javers() {
        JaversSqlRepository javersRepository = SqlRepositoryBuilder.sqlRepository().withConnectionProvider(this.connectionProvider).withDialect(DialectName.valueOf((String)this.javersProperties.getDialect().toUpperCase())).build();
        return JaversBuilder.javers().withListCompareAlgorithm(ListCompareAlgorithm.valueOf((String)this.javersProperties.getAlgorithm().toUpperCase())).withMappingStyle(MappingStyle.valueOf((String)this.javersProperties.getMappingStyle().toUpperCase())).withNewObjectsSnapshot(this.javersProperties.isNewObjectSnapshot()).withPrettyPrint(this.javersProperties.isPrettyPrint()).withTypeSafeValues(this.javersProperties.isTypeSafeValues()).registerJaversRepository((JaversRepository)javersRepository).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthorProvider authorProvider() {
        return new AuthorProvider(){

            public String provide() {
                return "unknown";
            }
        };
    }

    @Bean
    public JaversAuditableRepositoryAspect javersAuditableRepositoryAspect(Javers javers, AuthorProvider authorProvider) {
        return new JaversAuditableRepositoryAspect(javers, authorProvider);
    }
}

