/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.boot.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.JaversBuilderPlugin;
import org.javers.core.JaversCoreProperties;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.mongo.MongoDialect;
import org.javers.repository.mongo.MongoRepository;
import org.javers.repository.mongo.MongoRepositoryConfigurationBuilder;
import org.javers.spring.RegisterJsonTypeAdaptersPlugin;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;
import org.javers.spring.auditable.EmptyPropertiesProvider;
import org.javers.spring.auditable.MockAuthorProvider;
import org.javers.spring.auditable.SpringSecurityAuthorProvider;
import org.javers.spring.auditable.aspect.JaversAuditableAspect;
import org.javers.spring.auditable.aspect.springdata.JaversSpringDataAuditableRepositoryAspect;
import org.javers.spring.boot.mongo.JaversDedicatedMongoFactory;
import org.javers.spring.boot.mongo.JaversMongoProperties;
import org.javers.spring.mongodb.TransactionalMongoJaversBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoDatabaseUtils;
import org.springframework.data.mongodb.MongoTransactionManager;

@Configuration
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={JaversMongoProperties.class})
@Import(value={RegisterJsonTypeAdaptersPlugin.class})
public class JaversMongoAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(JaversMongoAutoConfiguration.class);
    @Autowired
    private JaversMongoProperties javersMongoProperties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private MongoProperties mongoProperties;
    @Autowired
    @Qualifier(value="javersMongoClientSettings")
    private Optional<MongoClientSettings> mongoClientSettings;
    @Autowired
    private MongoDatabaseFactory dbFactory;
    @Autowired(required=false)
    private List<JaversBuilderPlugin> plugins = new ArrayList<JaversBuilderPlugin>();
    @Autowired
    private Optional<MongoTransactionManager> mongoTransactionManager;
    @Value(value="${spring.data.mongodb.database:#{null}}")
    Optional<String> mongoDbName;

    @Bean(name={"JaversFromStarter"})
    @ConditionalOnMissingBean
    public Javers javers() {
        logger.info("Starting javers-spring-boot-starter-mongo ...");
        MongoDatabase mongoDatabase = this.initJaversMongoDatabase();
        MongoRepository javersRepository = this.createMongoRepository(mongoDatabase);
        JaversBuilder javersBuilder = TransactionalMongoJaversBuilder.javers().registerJaversRepository((JaversRepository)javersRepository).withTxManager((MongoTransactionManager)this.mongoTransactionManager.orElse(null)).withProperties((JaversCoreProperties)this.javersMongoProperties).withObjectAccessHook(this.javersMongoProperties.createObjectAccessHookInstance());
        this.plugins.forEach(plugin -> plugin.beforeAssemble(javersBuilder));
        return javersBuilder.build();
    }

    private MongoRepository createMongoRepository(MongoDatabase mongoDatabase) {
        if (this.javersMongoProperties.isDocumentDbCompatibilityEnabled()) {
            logger.info("enabling Amazon DocumentDB compatibility");
            return new MongoRepository(mongoDatabase, MongoRepositoryConfigurationBuilder.mongoRepositoryConfiguration().withSnapshotCollectionName(this.javersMongoProperties.getSnapshotCollectionName()).withHeadCollectionName(this.javersMongoProperties.getHeadCollectionName()).withCacheSize(this.javersMongoProperties.getSnapshotsCacheSize()).withDialect(MongoDialect.DOCUMENT_DB).withSchemaManagementEnabled(this.javersMongoProperties.isSchemaManagementEnabled()).build());
        }
        return new MongoRepository(mongoDatabase, MongoRepositoryConfigurationBuilder.mongoRepositoryConfiguration().withSnapshotCollectionName(this.javersMongoProperties.getSnapshotCollectionName()).withHeadCollectionName(this.javersMongoProperties.getHeadCollectionName()).withCacheSize(this.javersMongoProperties.getSnapshotsCacheSize()).withSchemaManagementEnabled(this.javersMongoProperties.isSchemaManagementEnabled()).build());
    }

    private MongoDatabase initJaversMongoDatabase() {
        if (!this.javersMongoProperties.isDedicatedMongodbConfigurationEnabled()) {
            return this.mongoDbName.map(name -> {
                logger.info("connecting Javers to Mongo database '{}' configured in the spring.data.mongodb.database property", name);
                return MongoDatabaseUtils.getDatabase((String)name, (MongoDatabaseFactory)this.dbFactory);
            }).orElseGet(() -> {
                MongoDatabase mongoDatabase = MongoDatabaseUtils.getDatabase((MongoDatabaseFactory)this.dbFactory);
                logger.info("connecting Javers to Spring's default Mongo database: '{}'", (Object)mongoDatabase.getName());
                return mongoDatabase;
            });
        }
        MongoDatabase mongoDatabase = JaversDedicatedMongoFactory.createMongoDatabase(this.javersMongoProperties, this.mongoClientSettings);
        logger.info("connecting Javers to dedicated Mongo database '{}' configured in javers.mongodb properties", (Object)mongoDatabase.getName());
        return mongoDatabase;
    }

    @Bean(name={"SpringSecurityAuthorProvider"})
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.security.core.context.SecurityContextHolder"})
    public AuthorProvider springSecurityAuthorProvider() {
        return new SpringSecurityAuthorProvider();
    }

    @Bean(name={"MockAuthorProvider"})
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.security.core.context.SecurityContextHolder"})
    public AuthorProvider unknownAuthorProvider() {
        return new MockAuthorProvider();
    }

    @Bean(name={"EmptyPropertiesProvider"})
    @ConditionalOnMissingBean
    public CommitPropertiesProvider commitPropertiesProvider() {
        return new EmptyPropertiesProvider();
    }

    @Bean
    @ConditionalOnProperty(name={"javers.auditableAspectEnabled"}, havingValue="true", matchIfMissing=true)
    public JaversAuditableAspect javersAuditableAspect(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        return new JaversAuditableAspect(javers, authorProvider, commitPropertiesProvider);
    }

    @Bean
    @ConditionalOnProperty(name={"javers.springDataAuditableRepositoryAspectEnabled"}, havingValue="true", matchIfMissing=true)
    public JaversSpringDataAuditableRepositoryAspect javersSpringDataAuditableAspect(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        return new JaversSpringDataAuditableRepositoryAspect(javers, authorProvider, commitPropertiesProvider);
    }
}

