/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.boot.mongo;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.MappingStyle;
import org.javers.core.diff.ListCompareAlgorithm;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.mongo.MongoRepository;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;
import org.javers.spring.auditable.EmptyPropertiesProvider;
import org.javers.spring.auditable.MockAuthorProvider;
import org.javers.spring.auditable.SpringSecurityAuthorProvider;
import org.javers.spring.auditable.aspect.JaversAuditableAspect;
import org.javers.spring.auditable.aspect.springdata.JaversSpringDataAuditableRepositoryAspect;
import org.javers.spring.boot.mongo.JaversProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={JaversProperties.class})
public class JaversMongoAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(JaversMongoAutoConfiguration.class);
    @Autowired
    private JaversProperties javersProperties;
    @Autowired
    private MongoClient mongoClient;
    @Autowired
    private MongoProperties mongoProperties;

    @Bean
    public Javers javers() {
        logger.info("Starting javers-spring-boot-starter-mongo ...");
        MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.mongoProperties.getMongoClientDatabase());
        logger.info("connecting to database: {}", (Object)this.mongoProperties.getMongoClientDatabase());
        MongoRepository javersRepository = new MongoRepository(mongoDatabase);
        return JaversBuilder.javers().withListCompareAlgorithm(ListCompareAlgorithm.valueOf((String)this.javersProperties.getAlgorithm().toUpperCase())).withMappingStyle(MappingStyle.valueOf((String)this.javersProperties.getMappingStyle().toUpperCase())).withNewObjectsSnapshot(this.javersProperties.isNewObjectSnapshot()).withPrettyPrint(this.javersProperties.isPrettyPrint()).withTypeSafeValues(this.javersProperties.isTypeSafeValues()).registerJaversRepository((JaversRepository)javersRepository).build();
    }

    @Bean(name={"authorProvider"})
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.security.core.context.SecurityContextHolder"})
    public AuthorProvider springSecurityAuthorProvider() {
        return new SpringSecurityAuthorProvider();
    }

    @Bean(name={"authorProvider"})
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.security.core.context.SecurityContextHolder"})
    public AuthorProvider unknownAuthorProvider() {
        return new MockAuthorProvider();
    }

    @Bean(name={"commitPropertiesProvider"})
    @ConditionalOnMissingBean
    public CommitPropertiesProvider commitPropertiesProvider() {
        return new EmptyPropertiesProvider();
    }

    @Bean
    public JaversAuditableAspect javersAuditableAspect(Javers javers, AuthorProvider authorProvider) {
        return new JaversAuditableAspect(javers, authorProvider, this.commitPropertiesProvider());
    }

    @Bean
    public JaversSpringDataAuditableRepositoryAspect javersSpringDataAuditableAspect(Javers javers, AuthorProvider authorProvider) {
        return new JaversSpringDataAuditableRepositoryAspect(javers, authorProvider, this.commitPropertiesProvider());
    }
}

