/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql;

import java.util.Optional;
import org.javers.common.validation.Validate;

public class SqlRepositoryConfiguration {
    private final boolean globalIdCacheDisabled;
    private final String schemaName;
    private final boolean schemaManagementEnabled;
    private final String globalIdTableName;
    private final String commitTableName;
    private final String snapshotTableName;
    private final String commitPropertyTableName;
    private final String globalIdSequenceName;
    private final String commitSequenceName;
    private final String snapshotSequenceName;

    SqlRepositoryConfiguration(boolean globalIdCacheDisabled, String schemaName, boolean schemaManagementEnabled, String globalIdTableName, String commitTableName, String snapshotTableName, String commitPropertyTableName, String globalIdSequenceName, String commitSequenceName, String snapshotSequenceName) {
        Validate.argumentCheck((schemaName == null || !schemaName.isEmpty() ? 1 : 0) != 0, (String)"schemaName should be null or non-empty");
        this.globalIdCacheDisabled = globalIdCacheDisabled;
        this.schemaName = schemaName;
        this.schemaManagementEnabled = schemaManagementEnabled;
        this.globalIdTableName = globalIdTableName;
        this.commitTableName = commitTableName;
        this.snapshotTableName = snapshotTableName;
        this.commitPropertyTableName = commitPropertyTableName;
        this.globalIdSequenceName = globalIdSequenceName;
        this.commitSequenceName = commitSequenceName;
        this.snapshotSequenceName = snapshotSequenceName;
    }

    public boolean isGlobalIdCacheDisabled() {
        return this.globalIdCacheDisabled;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Optional<String> getSchemaNameAsOptional() {
        return Optional.ofNullable(this.schemaName);
    }

    public boolean isSchemaManagementEnabled() {
        return this.schemaManagementEnabled;
    }

    public Optional<String> getGlobalIdTableName() {
        return Optional.ofNullable(this.globalIdTableName);
    }

    public Optional<String> getCommitTableName() {
        return Optional.ofNullable(this.commitTableName);
    }

    public Optional<String> getSnapshotTableName() {
        return Optional.ofNullable(this.snapshotTableName);
    }

    public Optional<String> getCommitPropertyTableName() {
        return Optional.ofNullable(this.commitPropertyTableName);
    }

    public Optional<String> getGlobalIdSequenceName() {
        return Optional.ofNullable(this.globalIdSequenceName);
    }

    public Optional<String> getCommitSequenceName() {
        return Optional.ofNullable(this.commitSequenceName);
    }

    public Optional<String> getSnapshotSequenceName() {
        return Optional.ofNullable(this.snapshotSequenceName);
    }
}

