/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.session;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.string.ToStringBuilder;
import org.javers.repository.sql.ConnectionProvider;
import org.javers.repository.sql.session.Insert;
import org.javers.repository.sql.session.ObjectMapper;
import org.javers.repository.sql.session.Query;
import org.javers.repository.sql.session.Select;

class PreparedStatementExecutor {
    private final PreparedStatement statement;
    private final String rawSql;
    private final String queryName;
    private int executionCount;
    private long executionTotalMillis;

    PreparedStatementExecutor(ConnectionProvider connectionProvider, Query query) {
        this.rawSql = query.rawSQl();
        this.queryName = query.name();
        this.statement = this.wrapExceptionAndCall(() -> connectionProvider.getConnection().prepareStatement(this.rawSql));
    }

    int getExecutionCount() {
        return this.executionCount;
    }

    long getExecutionTotalMillis() {
        return this.executionTotalMillis;
    }

    void execute(Insert insertQuery) {
        this.runVoidSql(() -> {
            insertQuery.injectValuesTo(this.statement);
            this.statement.executeUpdate();
        });
    }

    long executeQueryForLong(Select select) {
        return this.executeQueryForValue(select, resultSet -> resultSet.getLong(1));
    }

    Optional<BigDecimal> executeQueryForOptionalBigDecimal(Select select) {
        return this.executeQueryForOptionalValue(select, resultSet -> resultSet.getBigDecimal(1));
    }

    Optional<Long> executeQueryForOptionalLong(Select select) {
        return this.executeQueryForOptionalValue(select, resultSet -> resultSet.getLong(1));
    }

    List<Long> executeQueryForListOfLong(Select select) {
        return this.executeQueryForListOfLong(select, resultSet -> resultSet.getLong(1));
    }

    <T> List<T> executeQuery(Select select, ObjectMapper<T> objectMapper) {
        return this.runSql(() -> {
            select.injectValuesTo(this.statement);
            ArrayList result = new ArrayList();
            try (ResultSet rset = this.statement.executeQuery();){
                while (rset.next()) {
                    result.add(objectMapper.get(rset));
                }
            }
            return Collections.unmodifiableList(result);
        });
    }

    private <T> T executeQueryForValue(Select select, ObjectMapper<T> objectMapper) {
        return (T)this.runSql(() -> {
            select.injectValuesTo(this.statement);
            try (ResultSet rset = this.statement.executeQuery();){
                rset.next();
                Object t = objectMapper.get(rset);
                return t;
            }
        });
    }

    private <T> Optional<T> executeQueryForOptionalValue(Select select, ObjectMapper<T> objectMapper) {
        return this.runSql(() -> {
            select.injectValuesTo(this.statement);
            try (ResultSet rset = this.statement.executeQuery();){
                if (rset.next()) {
                    Optional optional = Optional.ofNullable(objectMapper.get(rset));
                    return optional;
                }
                Optional optional = Optional.empty();
                return optional;
            }
        });
    }

    private <T> List<T> executeQueryForListOfLong(Select select, ObjectMapper<T> objectMapper) {
        return this.runSql(() -> {
            select.injectValuesTo(this.statement);
            ArrayList result = new ArrayList();
            try (ResultSet rset = this.statement.executeQuery();){
                while (rset.next()) {
                    result.add(objectMapper.get(rset));
                }
            }
            return result;
        });
    }

    void close() {
        this.wrapExceptionAndCall(() -> this.statement.close());
    }

    private <T> T runSql(SqlAction<T> action) {
        long start = System.currentTimeMillis();
        T result = this.wrapExceptionAndCall(action);
        ++this.executionCount;
        this.executionTotalMillis += System.currentTimeMillis() - start;
        return result;
    }

    private void runVoidSql(SqlVoidAction action) {
        long start = System.currentTimeMillis();
        this.wrapExceptionAndCall(action);
        ++this.executionCount;
        this.executionTotalMillis += System.currentTimeMillis() - start;
    }

    private void wrapExceptionAndCall(SqlVoidAction action) {
        try {
            action.call();
        }
        catch (SQLException e) {
            throw new JaversException(JaversExceptionCode.SQL_EXCEPTION, new Object[]{e.getMessage(), this.rawSql});
        }
    }

    private <T> T wrapExceptionAndCall(SqlAction<T> action) {
        try {
            return action.callAndGet();
        }
        catch (SQLException e) {
            throw new JaversException(JaversExceptionCode.SQL_EXCEPTION, new Object[]{e.getMessage(), this.rawSql});
        }
    }

    String printStats() {
        return ToStringBuilder.rPad((String)this.queryName, (int)32) + " executed " + this.executionCount + " time(s) in " + this.executionTotalMillis + " millis, SQL: " + this.rawSql;
    }

    @FunctionalInterface
    private static interface SqlVoidAction {
        public void call() throws SQLException;
    }

    @FunctionalInterface
    private static interface SqlAction<T> {
        public T callAndGet() throws SQLException;
    }
}

