/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.repositories;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Optional;
import org.javers.core.commit.CommitId;
import org.javers.core.json.typeadapter.util.UtilTypeCoreAdapters;
import org.javers.repository.sql.schema.SchemaNameAware;
import org.javers.repository.sql.schema.TableNameProvider;
import org.javers.repository.sql.session.Session;
import org.polyjdbc.core.type.Timestamp;

public class CommitMetadataRepository
extends SchemaNameAware {
    public CommitMetadataRepository(TableNameProvider tableNameProvider) {
        super(tableNameProvider);
    }

    public long save(String author, Map<String, String> properties, LocalDateTime date, Instant dateInstant, CommitId commitId, Session session) {
        long commitPk = session.insert("Commit").into(this.getCommitTableNameWithSchema()).value("author", author).value("commit_date", date).value("commit_date_instant", UtilTypeCoreAdapters.serialize((Instant)dateInstant)).value("commit_id", commitId.valueAsNumber()).sequence("commit_pk", this.getCommitPkSeqName().nameWithSchema()).executeAndGetSequence();
        this.insertCommitProperties(commitPk, properties, session);
        return commitPk;
    }

    private void insertCommitProperties(long commitPk, Map<String, String> properties, Session session) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            session.insert("CommitProperty").into(this.getCommitPropertyTableNameWithSchema()).value("commit_fk", commitPk).value("property_name", property.getKey()).value("property_value", property.getValue()).execute();
        }
    }

    boolean isCommitPersisted(CommitId commitId, Session session) {
        long count = session.select("count(*)").from(this.getCommitTableNameWithSchema()).and("commit_id", commitId.valueAsNumber()).queryForLong("isCommitPersisted");
        return count > 0L;
    }

    private Timestamp toTimestamp(LocalDateTime commitMetadata) {
        return new Timestamp(UtilTypeCoreAdapters.toUtilDate((LocalDateTime)commitMetadata));
    }

    public CommitId getCommitHeadId(Session session) {
        Optional<BigDecimal> maxCommitId = this.selectMaxCommitId(session);
        return maxCommitId.map(max -> CommitId.valueOf((BigDecimal)((BigDecimal)maxCommitId.get()))).orElse(null);
    }

    private Optional<BigDecimal> selectMaxCommitId(Session session) {
        return session.select("MAX(commit_id)").from(this.getCommitTableNameWithSchema()).queryForOptionalBigDecimal("max CommitId");
    }
}

