/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql;

import java.util.Optional;
import org.javers.common.validation.Validate;

public class SqlRepositoryConfiguration {
    private final boolean globalIdCacheDisabled;
    private final String schemaName;
    private final boolean schemaManagementEnabled;

    SqlRepositoryConfiguration(boolean globalIdCacheDisabled, String schemaName, boolean schemaManagementEnabled) {
        Validate.argumentCheck((schemaName == null || !schemaName.isEmpty() ? 1 : 0) != 0, (String)"schemaName should be null or non-empty");
        this.globalIdCacheDisabled = globalIdCacheDisabled;
        this.schemaName = schemaName;
        this.schemaManagementEnabled = schemaManagementEnabled;
    }

    public boolean isGlobalIdCacheDisabled() {
        return this.globalIdCacheDisabled;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Optional<String> getSchemaNameAsOptional() {
        return Optional.ofNullable(this.schemaName);
    }

    public boolean isSchemaManagementEnabled() {
        return this.schemaManagementEnabled;
    }
}

