/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.session;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.javers.common.collections.Lists;
import org.javers.common.validation.Validate;
import org.javers.repository.sql.ConnectionProvider;
import org.javers.repository.sql.session.Dialect;
import org.javers.repository.sql.session.Insert;
import org.javers.repository.sql.session.InsertBuilder;
import org.javers.repository.sql.session.KeyGenerator;
import org.javers.repository.sql.session.ObjectMapper;
import org.javers.repository.sql.session.Parameter;
import org.javers.repository.sql.session.PreparedStatementExecutor;
import org.javers.repository.sql.session.Query;
import org.javers.repository.sql.session.Select;
import org.javers.repository.sql.session.SelectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session
implements AutoCloseable {
    public static final String SQL_LOGGER_NAME = "org.javers.SQL";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.javers.SQL");
    private final Dialect dialect;
    private final Map<String, PreparedStatementExecutor> statementExecutors = new HashMap<String, PreparedStatementExecutor>();
    private final ConnectionProvider connectionProvider;
    private final String sessionName;
    private final KeyGenerator keyGenerator;

    Session(Dialect dialect, KeyGenerator keyGenerator, ConnectionProvider connectionProvider, String sessionName) {
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
        this.sessionName = sessionName;
        this.keyGenerator = keyGenerator;
    }

    public SelectBuilder select(String selectClauseSQL) {
        return new SelectBuilder(this, selectClauseSQL);
    }

    public InsertBuilder insert(String queryName) {
        return new InsertBuilder(this, queryName);
    }

    long executeInsertAndGetSequence(String queryName, List<Parameter> parameters, String tableName, String primaryKeyFieldName, String sequenceName) {
        Validate.argumentsAreNotNull((Object[])new Object[]{queryName, parameters, tableName, primaryKeyFieldName, sequenceName});
        if (this.dialect.supportsSequences()) {
            long newId = this.keyGenerator.generateKey(sequenceName, this);
            Insert insertQuery = new Insert(queryName, Lists.add(parameters, (Object)new Parameter.LongParameter(primaryKeyFieldName, newId)), tableName);
            this.execute(insertQuery);
            return newId;
        }
        Insert insertQuery = new Insert(queryName, parameters, tableName);
        this.execute(insertQuery);
        return this.keyGenerator.getKeyFromLastInsert(this);
    }

    void executeInsert(String queryName, List<Parameter> parameters, String tableName, String primaryKeyFieldName, String sequenceName) {
        Validate.argumentsAreNotNull((Object[])new Object[]{queryName, parameters, tableName});
        if (this.dialect.supportsSequences() && sequenceName != null) {
            long newId = this.keyGenerator.generateKey(sequenceName, this);
            Insert insertQuery = new Insert(queryName, Lists.add(parameters, (Object)new Parameter.LongParameter(primaryKeyFieldName, newId)), tableName);
            this.execute(insertQuery);
        } else {
            Insert insertQuery = new Insert(queryName, parameters, tableName);
            this.execute(insertQuery);
        }
    }

    long executeQueryForLong(Select select) {
        PreparedStatementExecutor executor = this.getOrCreatePreparedStatement(select);
        return executor.executeQueryForLong(select);
    }

    Optional<BigDecimal> executeQueryForOptionalBigDecimal(Select select) {
        PreparedStatementExecutor executor = this.getOrCreatePreparedStatement(select);
        return executor.executeQueryForOptionalBigDecimal(select);
    }

    Optional<Long> executeQueryForOptionalLong(Select select) {
        PreparedStatementExecutor executor = this.getOrCreatePreparedStatement(select);
        return executor.executeQueryForOptionalLong(select);
    }

    <T> List<T> executeQuery(Select select, ObjectMapper<T> objectMapper) {
        PreparedStatementExecutor executor = this.getOrCreatePreparedStatement(select);
        return executor.executeQuery(select, objectMapper);
    }

    private void execute(Insert insertQuery) {
        PreparedStatementExecutor executor = this.getOrCreatePreparedStatement(insertQuery);
        executor.execute(insertQuery);
    }

    @Override
    public void close() {
        this.statementExecutors.values().stream().forEach(p -> p.close());
        this.logStats();
    }

    private PreparedStatementExecutor getOrCreatePreparedStatement(Query query) {
        if (this.statementExecutors.containsKey(query.name())) {
            return this.statementExecutors.get(query.name());
        }
        PreparedStatementExecutor executor = new PreparedStatementExecutor(this.connectionProvider, query);
        this.statementExecutors.put(query.name(), executor);
        return executor;
    }

    public void logStats() {
        logger.trace("SQL session '" + this.sessionName + "' finished. {} statement(s) executed in {} millis.", (Object)this.statementExecutors.values().stream().mapToInt(i -> i.getExecutionCount()).sum(), (Object)this.statementExecutors.values().stream().mapToLong(i -> i.getExecutionTotalMillis()).sum());
        ArrayList<PreparedStatementExecutor> executors = new ArrayList<PreparedStatementExecutor>(this.statementExecutors.values());
        Collections.sort(executors, (e1, e2) -> e2.getExecutionTotalMillis() > e1.getExecutionTotalMillis() ? 1 : -1);
    }

    Dialect getDialect() {
        return this.dialect;
    }
}

