/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.repositories;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.repository.sql.SqlRepositoryConfiguration;
import org.javers.repository.sql.schema.SchemaNameAware;
import org.javers.repository.sql.schema.TableNameProvider;
import org.javers.repository.sql.session.InsertBuilder;
import org.javers.repository.sql.session.SelectBuilder;
import org.javers.repository.sql.session.Session;

public class GlobalIdRepository
extends SchemaNameAware {
    private JsonConverter jsonConverter;
    private final boolean disableCache;
    private Cache<GlobalId, Long> globalIdPkCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public GlobalIdRepository(TableNameProvider tableNameProvider, SqlRepositoryConfiguration configuration) {
        super(tableNameProvider);
        this.disableCache = configuration.isGlobalIdCacheDisabled();
    }

    public long getOrInsertId(GlobalId globalId, Session session) {
        Optional<Long> pk = this.findGlobalIdPk(globalId, session);
        return pk.isPresent() ? pk.get().longValue() : this.insert(globalId, session);
    }

    public void evictCache() {
        this.globalIdPkCache.invalidateAll();
    }

    public int getGlobalIdPkCacheSize() {
        return (int)this.globalIdPkCache.size();
    }

    public Optional<Long> findGlobalIdPk(GlobalId globalId, Session session) {
        if (this.disableCache) {
            return this.findGlobalIdPkInDB(globalId, session);
        }
        Long foundPk = (Long)this.globalIdPkCache.getIfPresent((Object)globalId);
        if (foundPk != null) {
            return Optional.of(foundPk);
        }
        Optional<Long> fresh = this.findGlobalIdPkInDB(globalId, session);
        if (fresh.isPresent()) {
            this.globalIdPkCache.put((Object)globalId, (Object)fresh.get());
        }
        return fresh;
    }

    private Optional<Long> findGlobalIdPkInDB(GlobalId globalId, Session session) {
        SelectBuilder select = session.select("global_id_pk").from(this.getGlobalIdTableNameWithSchema());
        if (globalId instanceof ValueObjectId) {
            ValueObjectId valueObjectId = (ValueObjectId)globalId;
            Optional<Long> ownerFk = this.findGlobalIdPk(valueObjectId.getOwnerId(), session);
            if (!ownerFk.isPresent()) {
                return Optional.empty();
            }
            select.and("fragment", valueObjectId.getFragment()).and("owner_id_fk", ownerFk.get()).queryName("find PK of valueObjectId");
        } else if (globalId instanceof InstanceId) {
            select.and("local_id", this.jsonConverter.toJson(((InstanceId)globalId).getCdoId())).and("type_name", globalId.getTypeName()).queryName("find PK of InstanceId");
        } else if (globalId instanceof UnboundedValueObjectId) {
            select.and("type_name", globalId.getTypeName()).queryName("find PK of UnboundedValueObjectId");
        }
        return select.queryForOptionalLong();
    }

    private long insert(GlobalId globalId, Session session) {
        InsertBuilder insert = null;
        if (globalId instanceof ValueObjectId) {
            insert = session.insert("ValueObjectId");
            ValueObjectId valueObjectId = (ValueObjectId)globalId;
            long ownerFk = this.getOrInsertId(valueObjectId.getOwnerId(), session);
            insert.value("fragment", valueObjectId.getFragment()).value("owner_id_fk", ownerFk);
        } else if (globalId instanceof InstanceId) {
            insert = session.insert("InstanceId").value("type_name", globalId.getTypeName()).value("local_id", this.jsonConverter.toJson(((InstanceId)globalId).getCdoId()));
        } else if (globalId instanceof UnboundedValueObjectId) {
            insert = session.insert("UnboundedValueObjectId").value("type_name", globalId.getTypeName());
        }
        return insert.into(this.getGlobalIdTableNameWithSchema()).sequence("global_id_pk", this.getGlobalIdPkSeqWithSchema()).executeAndGetSequence();
    }

    public void setJsonConverter(JsonConverter JSONConverter) {
        this.jsonConverter = JSONConverter;
    }
}

