/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Sets;
import org.javers.core.json.CdoSnapshotSerialized;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.sql.finders.CdoSnapshotsEnricher;
import org.javers.repository.sql.finders.CommitPropertyDTO;
import org.javers.repository.sql.finders.CommitPropertyFinder;
import org.javers.repository.sql.finders.SnapshotQuery;
import org.javers.repository.sql.repositories.GlobalIdRepository;
import org.javers.repository.sql.schema.TableNameProvider;
import org.javers.repository.sql.session.SelectBuilder;
import org.javers.repository.sql.session.Session;

public class CdoSnapshotFinder {
    private final GlobalIdRepository globalIdRepository;
    private final CommitPropertyFinder commitPropertyFinder;
    private final CdoSnapshotsEnricher cdoSnapshotsEnricher = new CdoSnapshotsEnricher();
    private JsonConverter jsonConverter;
    private final TableNameProvider tableNameProvider;

    public CdoSnapshotFinder(GlobalIdRepository globalIdRepository, CommitPropertyFinder commitPropertyFinder, TableNameProvider tableNameProvider) {
        this.globalIdRepository = globalIdRepository;
        this.commitPropertyFinder = commitPropertyFinder;
        this.tableNameProvider = tableNameProvider;
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId, Session session, boolean loadCommitProps) {
        Optional<Long> globalIdPk = this.globalIdRepository.findGlobalIdPk(globalId, session);
        if (!globalIdPk.isPresent()) {
            return Optional.empty();
        }
        return this.selectMaxSnapshotPrimaryKey(globalIdPk.get(), session).map(maxSnapshotId -> {
            QueryParams oneItemLimit = QueryParamsBuilder.withLimit((int)1).withCommitProps(loadCommitProps).build();
            return this.fetchCdoSnapshots(q -> q.addSnapshotPkFilter((long)maxSnapshotId), oneItemLimit, session).get(0);
        });
    }

    public List<CdoSnapshot> getSnapshots(QueryParams queryParams, Session session) {
        return this.fetchCdoSnapshots(q -> {}, queryParams, session);
    }

    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers, Session session) {
        List snapshotIdentifiersWithPk = snapshotIdentifiers.stream().map(si -> this.globalIdRepository.findGlobalIdPk(si.getGlobalId(), session).map(id -> new SnapshotQuery.SnapshotDbIdentifier((SnapshotIdentifier)si, (long)id))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        QueryParams queryParams = QueryParamsBuilder.withLimit((int)Integer.MAX_VALUE).build();
        return this.fetchCdoSnapshots(q -> q.addSnapshotIdentifiersFilter(snapshotIdentifiersWithPk), queryParams, session);
    }

    public List<CdoSnapshot> getStateHistory(Set<ManagedType> managedTypes, QueryParams queryParams, Session session) {
        Set managedTypeNames = Sets.transform(managedTypes, managedType -> managedType.getName());
        return this.fetchCdoSnapshots(q -> q.addManagedTypesFilter(managedTypeNames), queryParams, session);
    }

    public List<CdoSnapshot> getVOStateHistory(EntityType ownerEntity, String fragment, QueryParams queryParams, Session session) {
        return this.fetchCdoSnapshots(q -> q.addVoOwnerEntityFilter(ownerEntity.getName(), fragment), queryParams, session);
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams, Session session) {
        Optional<Long> globalIdPk = this.globalIdRepository.findGlobalIdPk(globalId, session);
        return globalIdPk.map(idPk -> this.fetchCdoSnapshots(q -> q.addGlobalIdFilter((long)idPk), queryParams, session)).orElse(Collections.emptyList());
    }

    private List<CdoSnapshot> fetchCdoSnapshots(Consumer<SnapshotQuery> additionalFilter, QueryParams queryParams, Session session) {
        SnapshotQuery query = new SnapshotQuery(this.tableNameProvider, queryParams, session);
        additionalFilter.accept(query);
        List<CdoSnapshotSerialized> serializedSnapshots = query.run();
        if (queryParams.isLoadCommitProps()) {
            List<CommitPropertyDTO> commitPropertyDTOs = this.commitPropertyFinder.findCommitPropertiesOfSnaphots(serializedSnapshots.stream().map(it -> it.getCommitPk()).collect(Collectors.toList()));
            this.cdoSnapshotsEnricher.enrichWithCommitProperties(serializedSnapshots, commitPropertyDTOs);
        }
        return Lists.transform(serializedSnapshots, serializedSnapshot -> this.jsonConverter.fromSerializedSnapshot(serializedSnapshot));
    }

    private Optional<Long> selectMaxSnapshotPrimaryKey(long globalIdPk, Session session) {
        Optional<Long> maxPrimaryKey = ((SelectBuilder)session.select("MAX(snapshot_pk)").from(this.tableNameProvider.getSnapshotTableNameWithSchema()).and("global_id_fk", globalIdPk).queryName("select max snapshot's PK")).queryForOptionalLong();
        if (maxPrimaryKey.isPresent() && maxPrimaryKey.get() == 0L) {
            return Optional.empty();
        }
        return maxPrimaryKey;
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }
}

