/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql;

import org.javers.core.AbstractContainerBuilder;
import org.javers.repository.sql.ConnectionProvider;
import org.javers.repository.sql.DialectName;
import org.javers.repository.sql.JaversSqlRepository;
import org.javers.repository.sql.SqlRepositoryConfiguration;
import org.javers.repository.sql.pico.JaversSqlModule;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.PolyJDBCBuilder;
import org.polyjdbc.core.dialect.Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlRepositoryBuilder
extends AbstractContainerBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SqlRepositoryBuilder.class);
    private DialectName dialectName;
    private ConnectionProvider connectionProvider;
    private String schemaName;
    private boolean globalIdCacheDisabled;
    private boolean schemaManagementEnabled = true;

    public static SqlRepositoryBuilder sqlRepository() {
        return new SqlRepositoryBuilder();
    }

    public SqlRepositoryBuilder withDialect(DialectName dialect) {
        this.dialectName = dialect;
        return this;
    }

    public SqlRepositoryBuilder withConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        return this;
    }

    public SqlRepositoryBuilder withSchema(String schemaName) {
        if (schemaName != null && !schemaName.isEmpty()) {
            this.schemaName = schemaName;
        }
        return this;
    }

    public SqlRepositoryBuilder withGlobalIdCacheDisabled() {
        this.globalIdCacheDisabled = true;
        return this;
    }

    public SqlRepositoryBuilder withSchemaManagementEnabled(boolean schemaManagementEnabled) {
        this.schemaManagementEnabled = schemaManagementEnabled;
        return this;
    }

    public JaversSqlRepository build() {
        logger.info("starting SqlRepository...");
        logger.info("  dialect:                 {}", (Object)this.dialectName);
        logger.info("  schemaManagementEnabled: {}", (Object)this.schemaManagementEnabled);
        logger.info("  schemaName:              {}", (Object)this.schemaName);
        this.bootContainer();
        SqlRepositoryConfiguration config = new SqlRepositoryConfiguration(this.globalIdCacheDisabled, this.schemaName, this.schemaManagementEnabled);
        this.addComponent(config);
        PolyJDBC polyJDBC = PolyJDBCBuilder.polyJDBC((Dialect)this.dialectName.getPolyDialect(), (String)config.getSchemaName()).usingManagedConnections(() -> this.connectionProvider.getConnection()).build();
        this.addComponent(polyJDBC);
        this.addModule(new JaversSqlModule());
        this.addComponent(this.dialectName.getPolyDialect());
        this.addComponent(this.connectionProvider);
        return this.getContainerComponent(JaversSqlRepository.class);
    }

    protected <T> T getContainerComponent(Class<T> ofClass) {
        return (T)super.getContainerComponent(ofClass);
    }
}

