/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.javers.common.string.ToStringBuilder;
import org.javers.core.commit.CommitId;
import org.javers.core.json.typeadapter.util.UtilTypeCoreAdapters;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.repository.api.QueryParams;
import org.javers.repository.sql.schema.SchemaNameAware;
import org.javers.repository.sql.schema.TableNameProvider;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.type.Timestamp;

abstract class SnapshotFilter
extends SchemaNameAware {
    private static final String BASE_FIELDS = "state, type, version, changed_properties, managed_type, commit_pk, author, commit_date, commit_id";
    static final String BASE_AND_GLOBAL_ID_FIELDS = "state, type, version, changed_properties, managed_type, commit_pk, author, commit_date, commit_id, g.local_id, g.fragment, g.owner_id_fk, o.local_id owner_local_id, o.fragment owner_fragment, o.type_name owner_type_name";

    SnapshotFilter(TableNameProvider tableNameProvider) {
        super(tableNameProvider);
    }

    protected String getFromCommitWithSnapshot() {
        return this.getSnapshotTableNameWithSchema() + " INNER JOIN " + this.getCommitTableNameWithSchema() + " ON " + "commit_pk" + " = " + "commit_fk" + " INNER JOIN " + this.getGlobalIdTableNameWithSchema() + " g ON g." + "global_id_pk" + " = " + "global_id_fk" + " LEFT OUTER JOIN " + this.getGlobalIdTableNameWithSchema() + " o ON o." + "global_id_pk" + " = g." + "owner_id_fk";
    }

    String select() {
        return BASE_AND_GLOBAL_ID_FIELDS;
    }

    void addFrom(SelectQuery query) {
        query.from(this.getFromCommitWithSnapshot());
    }

    abstract void addWhere(SelectQuery var1);

    void applyQueryParams(SelectQuery query, QueryParams queryParams) {
        if (queryParams.changedProperty().isPresent()) {
            query.append(" AND changed_properties like :changedProperty ").withArgument("changedProperty", (Object)("%\"" + (String)queryParams.changedProperty().get() + "\"%"));
        }
        if (queryParams.from().isPresent()) {
            query.append(" AND commit_date >= :commitFromDate").withArgument("commitFromDate", (Object)new Timestamp(UtilTypeCoreAdapters.toUtilDate((LocalDateTime)((LocalDateTime)queryParams.from().get()))));
        }
        if (queryParams.to().isPresent()) {
            query.append(" AND commit_date <= :commitToDate").withArgument("commitToDate", (Object)new Timestamp(UtilTypeCoreAdapters.toUtilDate((LocalDateTime)((LocalDateTime)queryParams.to().get()))));
        }
        if (queryParams.toCommitId().isPresent()) {
            query.append(" AND commit_id <= " + ((CommitId)queryParams.toCommitId().get()).valueAsNumber());
        }
        if (queryParams.commitIds().size() > 0) {
            query.append(" AND commit_id IN (" + ToStringBuilder.join((Collection)queryParams.commitIds().stream().map(c -> c.valueAsNumber()).collect(Collectors.toList())) + ")");
        }
        if (queryParams.version().isPresent()) {
            query.append(" AND version = :version").withArgument("version", queryParams.version().get());
        }
        if (queryParams.author().isPresent()) {
            query.append(" AND author = :author").withArgument("author", queryParams.author().get());
        }
        if (queryParams.commitProperties().size() > 0) {
            this.addCommitPropertyConditions(query, queryParams.commitProperties());
        }
        if (queryParams.snapshotType().isPresent()) {
            query.append(" AND type = :snapshotType").withArgument("snapshotType", (Object)((SnapshotType)queryParams.snapshotType().get()).name());
        }
        query.limit(queryParams.limit(), queryParams.skip());
    }

    private void addCommitPropertyConditions(SelectQuery query, Map<String, String> commitProperties) {
        for (Map.Entry<String, String> commitProperty : commitProperties.entrySet()) {
            this.addCommitPropertyCondition(query, commitProperty.getKey(), commitProperty.getValue());
        }
    }

    private void addCommitPropertyCondition(SelectQuery query, String propertyName, String propertyValue) {
        query.append(" AND EXISTS (SELECT * FROM " + this.getCommitPropertyTableNameWithSchema() + " WHERE " + "commit_fk" + " = " + "commit_pk" + " AND " + "property_name" + " = :propertyName_" + propertyName + " AND " + "property_value" + " = :propertyValue_" + propertyName + ")").withArgument("propertyName_" + propertyName, (Object)propertyName).withArgument("propertyValue_" + propertyName, (Object)propertyValue);
    }
}

