/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.util.Collection;
import org.javers.common.collections.Optional;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.sql.finders.SnapshotFilter;
import org.javers.repository.sql.repositories.GlobalIdRepository;
import org.javers.repository.sql.schema.TableNameProvider;
import org.polyjdbc.core.query.SelectQuery;

class SnapshotIdentifiersFilter
extends SnapshotFilter {
    private final Collection<SnapshotIdentifier> snapshotIdentifiers;
    private final GlobalIdRepository globalIdRepository;

    public SnapshotIdentifiersFilter(TableNameProvider tableNameProvider, GlobalIdRepository globalIdRepository, Collection<SnapshotIdentifier> snapshotIdentifiers) {
        super(tableNameProvider);
        this.globalIdRepository = globalIdRepository;
        this.snapshotIdentifiers = snapshotIdentifiers;
    }

    @Override
    void addWhere(SelectQuery query) {
        query.where("1!=1");
        for (SnapshotIdentifier snapshotIdentifier : this.snapshotIdentifiers) {
            Optional<Long> globalIdPk = this.globalIdRepository.findGlobalIdPk(snapshotIdentifier.getGlobalId());
            if (!globalIdPk.isPresent()) continue;
            query.append(" OR (").append("global_id_fk").append(" = ").append(((Long)globalIdPk.get()).toString()).append(" AND ").append("version").append(" = ").append(Long.toString(snapshotIdentifier.getVersion())).append(")");
        }
    }
}

