/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.repositories;

import java.math.BigDecimal;
import java.util.Map;
import org.javers.common.collections.Optional;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.repository.sql.PolyUtil;
import org.javers.repository.sql.schema.SchemaNameAware;
import org.javers.repository.sql.schema.TableNameProvider;
import org.joda.time.LocalDateTime;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.InsertQuery;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.type.Timestamp;

public class CommitMetadataRepository
extends SchemaNameAware {
    private final PolyJDBC polyJDBC;

    public CommitMetadataRepository(PolyJDBC polyjdbc, TableNameProvider tableNameProvider) {
        super(tableNameProvider);
        this.polyJDBC = polyjdbc;
    }

    public long save(String author, Map<String, String> properties, LocalDateTime date, CommitId commitId) {
        long commitPk = this.insertCommit(author, date, commitId);
        this.insertCommitProperties(commitPk, properties);
        return commitPk;
    }

    private long insertCommit(String author, LocalDateTime date, CommitId commitId) {
        InsertQuery query = this.polyJDBC.query().insert().into(this.getCommitTableNameWithSchema()).value("author", (Object)author).value("commit_date", (Object)this.toTimestamp(date)).value("commit_id", (Object)commitId.valueAsNumber()).sequence("commit_pk", this.getCommitPkSeqWithSchema());
        return this.polyJDBC.queryRunner().insert(query);
    }

    private void insertCommitProperties(long commitPk, Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            InsertQuery query = this.polyJDBC.query().insert().into(this.getCommitPropertyTableNameWithSchema()).value("commit_fk", (Object)commitPk).value("property_name", (Object)property.getKey()).value("property_value", (Object)property.getValue());
            this.polyJDBC.queryRunner().insert(query);
        }
    }

    public boolean isPersisted(Commit commit) {
        SelectQuery selectQuery = this.polyJDBC.query().select("count(*)").from(this.getCommitTableNameWithSchema()).where("commit_id = :id").withArgument("id", (Object)commit.getId().valueAsNumber());
        return (Long)PolyUtil.queryForOptionalLong(selectQuery, this.polyJDBC).get() > 0L;
    }

    private Timestamp toTimestamp(LocalDateTime commitMetadata) {
        return new Timestamp(commitMetadata.toDate());
    }

    public CommitId getCommitHeadId() {
        Optional<BigDecimal> maxCommitId = this.selectMaxCommitId();
        return maxCommitId.isEmpty() ? null : CommitId.valueOf((BigDecimal)((BigDecimal)maxCommitId.get()));
    }

    private Optional<BigDecimal> selectMaxCommitId() {
        SelectQuery query = this.polyJDBC.query().select("MAX(commit_id)").from(this.getCommitTableNameWithSchema());
        return PolyUtil.queryForOptionalBigDecimal(query, this.polyJDBC);
    }
}

