/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.repositories;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.javers.common.collections.Optional;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.repository.sql.PolyUtil;
import org.javers.repository.sql.schema.SchemaNameAware;
import org.javers.repository.sql.schema.TableNameProvider;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.InsertQuery;
import org.polyjdbc.core.query.SelectQuery;

public class GlobalIdRepository
extends SchemaNameAware {
    private PolyJDBC polyJdbc;
    private JsonConverter jsonConverter;
    private Cache<GlobalId, Long> globalIdPkCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public GlobalIdRepository(PolyJDBC javersPolyjdbc, TableNameProvider tableNameProvider) {
        super(tableNameProvider);
        this.polyJdbc = javersPolyjdbc;
    }

    public long getOrInsertId(GlobalId globalId) {
        Optional<Long> pk = this.findGlobalIdPk(globalId);
        return pk.isPresent() ? ((Long)pk.get()).longValue() : this.insert(globalId);
    }

    public Optional<Long> findGlobalIdPk(GlobalId globalId) {
        Long foundPk = (Long)this.globalIdPkCache.getIfPresent((Object)globalId);
        if (foundPk != null) {
            return Optional.of((Object)foundPk);
        }
        Optional<Long> fresh = this.findGlobalIdPkInDB(globalId);
        if (fresh.isPresent()) {
            this.globalIdPkCache.put((Object)globalId, fresh.get());
        }
        return fresh;
    }

    private Optional<Long> findGlobalIdPkInDB(GlobalId globalId) {
        SelectQuery query = this.polyJdbc.query().select("global_id_pk").from(this.getGlobalIdTableNameWithSchema());
        if (globalId instanceof ValueObjectId) {
            ValueObjectId valueObjectId = (ValueObjectId)globalId;
            Optional<Long> ownerFk = this.findGlobalIdPk(valueObjectId.getOwnerId());
            if (ownerFk.isEmpty()) {
                return Optional.empty();
            }
            query.where("fragment = :fragment ").withArgument("fragment", (Object)valueObjectId.getFragment()).append("AND owner_id_fk = :ownerFk ").withArgument("ownerFk", ownerFk.get());
        } else if (globalId instanceof InstanceId) {
            query.where("local_id = :localId ").withArgument("localId", (Object)this.jsonConverter.toJson(((InstanceId)globalId).getCdoId())).append("AND type_name = :qualifiedName ").withArgument("qualifiedName", (Object)globalId.getTypeName());
        } else if (globalId instanceof UnboundedValueObjectId) {
            query.where("type_name = :qualifiedName ").withArgument("qualifiedName", (Object)globalId.getTypeName());
        }
        return PolyUtil.queryForOptionalLong(query, this.polyJdbc);
    }

    private long insert(GlobalId globalId) {
        InsertQuery query = this.polyJdbc.query().insert().into(this.getGlobalIdTableNameWithSchema());
        if (globalId instanceof ValueObjectId) {
            ValueObjectId valueObjectId = (ValueObjectId)globalId;
            long ownerFk = this.getOrInsertId(valueObjectId.getOwnerId());
            query.value("fragment", (Object)valueObjectId.getFragment()).value("owner_id_fk", (Object)ownerFk);
        } else if (globalId instanceof InstanceId) {
            query.value("type_name", (Object)globalId.getTypeName()).value("local_id", (Object)this.jsonConverter.toJson(((InstanceId)globalId).getCdoId()));
        } else if (globalId instanceof UnboundedValueObjectId) {
            query.value("type_name", (Object)globalId.getTypeName());
        }
        query.sequence("global_id_pk", this.getGlobalIdPkSeqWithSchema());
        return this.polyJdbc.queryRunner().insert(query);
    }

    public void setJsonConverter(JsonConverter JSONConverter) {
        this.jsonConverter = JSONConverter;
    }
}

