/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.repositories;

import java.util.List;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.repository.sql.repositories.GlobalIdRepository;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.InsertQuery;

public class CdoSnapshotRepository {
    private final PolyJDBC javersPolyJDBC;
    private JsonConverter jsonConverter;
    private final GlobalIdRepository globalIdRepository;

    public CdoSnapshotRepository(PolyJDBC javersPolyJDBC, GlobalIdRepository globalIdRepository) {
        this.javersPolyJDBC = javersPolyJDBC;
        this.globalIdRepository = globalIdRepository;
    }

    public void save(long commitIdPk, List<CdoSnapshot> cdoSnapshots) {
        for (CdoSnapshot cdoSnapshot : cdoSnapshots) {
            long globalIdPk = this.globalIdRepository.getOrInsertId(cdoSnapshot.getGlobalId());
            this.insertSnapshot(globalIdPk, commitIdPk, cdoSnapshot);
        }
    }

    private long insertSnapshot(long globalIdPk, long commitIdPk, CdoSnapshot cdoSnapshot) {
        InsertQuery query = this.javersPolyJDBC.query().insert().into("jv_snapshot").value("type", (Object)cdoSnapshot.getType().toString()).value("global_id_fk", (Object)globalIdPk).value("commit_fk", (Object)commitIdPk).value("version", (Object)cdoSnapshot.getVersion()).value("state", (Object)this.jsonConverter.toJson((Object)cdoSnapshot.getState())).value("changed_properties", (Object)this.jsonConverter.toJson((Object)cdoSnapshot.getChanged())).value("managed_type", (Object)cdoSnapshot.getManagedType().getName()).sequence("snapshot_pk", "jv_snapshot_pk_seq");
        return this.javersPolyJDBC.queryRunner().insert(query);
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }
}

