/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.schema;

import java.util.Map;
import java.util.TreeMap;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.schema.model.LongAttributeBuilder;
import org.polyjdbc.core.schema.model.RelationBuilder;
import org.polyjdbc.core.schema.model.Schema;
import org.polyjdbc.core.util.StringUtils;

public class FixedSchemaFactory {
    public static final String GLOBAL_ID_TABLE_NAME = "jv_global_id";
    public static final String GLOBAL_ID_PK = "global_id_pk";
    public static final String GLOBAL_ID_LOCAL_ID = "local_id";
    public static final String GLOBAL_ID_FRAGMENT = "fragment";
    public static final String GLOBAL_ID_TYPE_NAME = "type_name";
    public static final String GLOBAL_ID_OWNER_ID_FK = "owner_id_fk";
    public static final String GLOBAL_ID_PK_SEQ = "jv_global_id_pk_seq";
    public static final String COMMIT_TABLE_NAME = "jv_commit";
    public static final String COMMIT_PK = "commit_pk";
    public static final String COMMIT_AUTHOR = "author";
    public static final String COMMIT_COMMIT_DATE = "commit_date";
    public static final String COMMIT_COMMIT_ID = "commit_id";
    public static final String COMMIT_PK_SEQ = "jv_commit_pk_seq";
    public static final String COMMIT_PROPERTY_TABLE_NAME = "jv_commit_property";
    public static final String COMMIT_PROPERTY_COMMIT_FK = "commit_fk";
    public static final String COMMIT_PROPERTY_NAME = "property_name";
    public static final String COMMIT_PROPERTY_VALUE = "property_value";
    public static final String SNAPSHOT_TABLE_NAME = "jv_snapshot";
    public static final String SNAPSHOT_PK = "snapshot_pk";
    public static final String SNAPSHOT_COMMIT_FK = "commit_fk";
    public static final String SNAPSHOT_GLOBAL_ID_FK = "global_id_fk";
    public static final String SNAPSHOT_TYPE = "type";
    public static final String SNAPSHOT_VERSION = "version";
    public static final String SNAPSHOT_TABLE_PK_SEQ = "jv_snapshot_pk_seq";
    public static final String SNAPSHOT_STATE = "state";
    public static final String SNAPSHOT_CHANGED = "changed_properties";
    public static final String SNAPSHOT_MANAGED_TYPE = "managed_type";

    private Schema snapshotTableSchema(Dialect dialect, String tableName) {
        Schema schema = new Schema(dialect);
        RelationBuilder relationBuilder = schema.addRelation(tableName);
        this.primaryKey(SNAPSHOT_PK, schema, relationBuilder);
        relationBuilder.withAttribute().string(SNAPSHOT_TYPE).withMaxLength(200).and().withAttribute().longAttr(SNAPSHOT_VERSION).and().withAttribute().text(SNAPSHOT_STATE).and().withAttribute().text(SNAPSHOT_CHANGED).and().withAttribute().string(SNAPSHOT_MANAGED_TYPE).withMaxLength(200).and();
        this.foreignKey(tableName, SNAPSHOT_GLOBAL_ID_FK, GLOBAL_ID_TABLE_NAME, GLOBAL_ID_PK, relationBuilder);
        this.foreignKey(tableName, "commit_fk", COMMIT_TABLE_NAME, COMMIT_PK, relationBuilder);
        relationBuilder.build();
        this.columnsIndex(tableName, schema, SNAPSHOT_GLOBAL_ID_FK);
        this.columnsIndex(tableName, schema, "commit_fk");
        return schema;
    }

    private Schema commitTableSchema(Dialect dialect, String tableName) {
        Schema schema = new Schema(dialect);
        RelationBuilder relationBuilder = schema.addRelation(tableName);
        this.primaryKey(COMMIT_PK, schema, relationBuilder);
        relationBuilder.withAttribute().string(COMMIT_AUTHOR).withMaxLength(200).and().withAttribute().timestamp(COMMIT_COMMIT_DATE).and().withAttribute().number(COMMIT_COMMIT_ID).withIntegerPrecision(12).withDecimalPrecision(2).and().build();
        this.columnsIndex(tableName, schema, COMMIT_COMMIT_ID);
        return schema;
    }

    private Schema commitPropertiesTableSchema(Dialect dialect, String tableName) {
        Schema schema = new Schema(dialect);
        RelationBuilder relationBuilder = schema.addRelation(tableName);
        relationBuilder.primaryKey(tableName + "_pk").using(new String[]{"commit_fk", COMMIT_PROPERTY_NAME}).and().withAttribute().string(COMMIT_PROPERTY_NAME).withMaxLength(200).and().withAttribute().string(COMMIT_PROPERTY_VALUE).withMaxLength(200).and();
        this.foreignKey(tableName, "commit_fk", COMMIT_TABLE_NAME, COMMIT_PK, relationBuilder);
        relationBuilder.build();
        this.columnsIndex(tableName, schema, "commit_fk");
        this.columnsIndex(tableName, schema, COMMIT_PROPERTY_NAME, COMMIT_PROPERTY_VALUE);
        return schema;
    }

    private Schema globalIdTableSchema(Dialect dialect, String tableName) {
        Schema schema = new Schema(dialect);
        RelationBuilder relationBuilder = schema.addRelation(tableName);
        this.primaryKey(GLOBAL_ID_PK, schema, relationBuilder);
        relationBuilder.withAttribute().string(GLOBAL_ID_LOCAL_ID).withMaxLength(200).and().withAttribute().string(GLOBAL_ID_FRAGMENT).withMaxLength(200).and().withAttribute().string(GLOBAL_ID_TYPE_NAME).withMaxLength(200).and();
        this.foreignKey(tableName, GLOBAL_ID_OWNER_ID_FK, GLOBAL_ID_TABLE_NAME, GLOBAL_ID_PK, relationBuilder);
        relationBuilder.build();
        this.columnsIndex(tableName, schema, GLOBAL_ID_LOCAL_ID);
        return schema;
    }

    private void foreignKey(String tableName, String fkColName, String targetTableName, String targetPkColName, RelationBuilder relationBuilder) {
        relationBuilder.withAttribute().longAttr(fkColName).and().foreignKey(tableName + "_" + fkColName).on(fkColName).references(targetTableName, targetPkColName).and();
    }

    private void columnsIndex(String tableName, Schema schema, String ... colNames) {
        String concatenatedColumnNames = StringUtils.concatenate((char)'_', (Object[])colNames);
        schema.addIndex(tableName + "_" + concatenatedColumnNames + "_idx").indexing(colNames).on(tableName).build();
    }

    private void primaryKey(String pkColName, Schema schema, RelationBuilder relationBuilder) {
        ((LongAttributeBuilder)((LongAttributeBuilder)relationBuilder.withAttribute().longAttr(pkColName).withAdditionalModifiers(new String[]{"AUTO_INCREMENT"})).notNull()).and().primaryKey("jv_" + pkColName).using(new String[]{pkColName}).and();
        schema.addSequence("jv_" + pkColName + "_seq").build();
    }

    public Map<String, Schema> allTablesSchema(Dialect dialect) {
        TreeMap<String, Schema> schema = new TreeMap<String, Schema>();
        schema.put(GLOBAL_ID_TABLE_NAME, this.globalIdTableSchema(dialect, GLOBAL_ID_TABLE_NAME));
        schema.put(COMMIT_TABLE_NAME, this.commitTableSchema(dialect, COMMIT_TABLE_NAME));
        schema.put(COMMIT_PROPERTY_TABLE_NAME, this.commitPropertiesTableSchema(dialect, COMMIT_PROPERTY_TABLE_NAME));
        schema.put(SNAPSHOT_TABLE_NAME, this.snapshotTableSchema(dialect, SNAPSHOT_TABLE_NAME));
        return schema;
    }
}

