/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.util.Collections;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.clazz.Entity;
import org.javers.core.metamodel.clazz.ManagedClass;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.repository.sql.PolyUtil;
import org.javers.repository.sql.finders.CdoSnapshotObjectMapper;
import org.javers.repository.sql.finders.GlobalIdFilter;
import org.javers.repository.sql.finders.ManagedClassFilter;
import org.javers.repository.sql.finders.SnapshotFilter;
import org.javers.repository.sql.finders.SnapshotIdFilter;
import org.javers.repository.sql.finders.VoOwnerEntityFilter;
import org.javers.repository.sql.reposiotries.GlobalIdRepository;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.Order;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.query.mapper.ObjectMapper;

public class CdoSnapshotFinder {
    private final PolyJDBC polyJDBC;
    private JsonConverter jsonConverter;
    private GlobalIdRepository globalIdRepository;

    public CdoSnapshotFinder(GlobalIdRepository globalIdRepository, PolyJDBC polyJDBC) {
        this.globalIdRepository = globalIdRepository;
        this.polyJDBC = polyJDBC;
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        Optional<Long> globalIdPk = this.globalIdRepository.findGlobalIdPk(globalId);
        if (globalIdPk.isEmpty()) {
            return Optional.empty();
        }
        Optional<Long> maxSnapshot = this.selectMaxSnapshotPrimaryKey((Long)globalIdPk.get());
        if (maxSnapshot.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Object)this.queryForCdoSnapshots(new SnapshotIdFilter((Long)maxSnapshot.get()), (Optional<GlobalId>)Optional.of((Object)globalId), 1).get(0));
    }

    public List<CdoSnapshot> getStateHistory(ManagedClass givenClass, Optional<String> propertyName, int limit) {
        Optional<Long> classPk = this.globalIdRepository.findClassPk(givenClass.getClientsClass());
        if (classPk.isEmpty()) {
            return Collections.emptyList();
        }
        ManagedClassFilter classFilter = new ManagedClassFilter((long)((Long)classPk.get()), propertyName);
        return this.queryForCdoSnapshots(classFilter, (Optional<GlobalId>)Optional.empty(), limit);
    }

    public List<CdoSnapshot> getVOStateHistory(Entity ownerEntity, String fragment, int limit) {
        Optional<Long> ownerEntityClassPk = this.globalIdRepository.findClassPk(ownerEntity.getClientsClass());
        if (ownerEntityClassPk.isEmpty()) {
            return Collections.emptyList();
        }
        VoOwnerEntityFilter voOwnerFilter = new VoOwnerEntityFilter((long)((Long)ownerEntityClassPk.get()), fragment);
        return this.queryForCdoSnapshots(voOwnerFilter, (Optional<GlobalId>)Optional.empty(), limit);
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, Optional<String> propertyName, int limit) {
        Optional<Long> globalIdPk = this.globalIdRepository.findGlobalIdPk(globalId);
        if (globalIdPk.isEmpty()) {
            return Collections.emptyList();
        }
        return this.queryForCdoSnapshots(new GlobalIdFilter((Long)globalIdPk.get(), propertyName), (Optional<GlobalId>)Optional.of((Object)globalId), limit);
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    private List<CdoSnapshot> queryForCdoSnapshots(SnapshotFilter snapshotFilter, Optional<GlobalId> providedGlobalId, int limit) {
        SelectQuery query = this.polyJDBC.query().select(snapshotFilter.select());
        snapshotFilter.addFrom(query);
        snapshotFilter.addWhere(query);
        query.orderBy("snapshot_pk", Order.DESC).limit(limit);
        return this.polyJDBC.queryRunner().queryList(query, (ObjectMapper)new CdoSnapshotObjectMapper(this.jsonConverter, providedGlobalId));
    }

    private Optional<Long> selectMaxSnapshotPrimaryKey(long globalIdPk) {
        SelectQuery query = this.polyJDBC.query().select("MAX(snapshot_pk)").from("jv_snapshot").where("global_id_fk = :globalIdPk").withArgument("globalIdPk", (Object)globalIdPk);
        Optional<Long> result = PolyUtil.queryForOptionalLong(query, this.polyJDBC);
        if (result.isPresent() && (Long)result.get() == 0L) {
            return Optional.empty();
        }
        return result;
    }
}

