/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.reposiotries;

import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.repository.sql.PolyUtil;
import org.javers.repository.sql.reposiotries.PersistentGlobalId;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.InsertQuery;
import org.polyjdbc.core.query.SelectQuery;

public class GlobalIdRepository {
    private PolyJDBC polyJdbc;
    private JsonConverter jsonConverter;

    public GlobalIdRepository(PolyJDBC javersPolyjdbc) {
        this.polyJdbc = javersPolyjdbc;
    }

    public PersistentGlobalId findPersistedGlobalId(GlobalId globalId) {
        if (globalId instanceof PersistentGlobalId) {
            PersistentGlobalId persistentGlobalId = (PersistentGlobalId)globalId;
            Validate.conditionFulfilled((boolean)persistentGlobalId.persisted(), (String)("unexpected empty persistentGlobalId: " + globalId.value()));
            return persistentGlobalId;
        }
        Optional<Long> globalIdPrimaryKey = this.findGlobalIdPk(globalId);
        return new PersistentGlobalId(globalId, globalIdPrimaryKey);
    }

    public long getOrInsertId(GlobalId globalId) {
        PersistentGlobalId lookup = this.findPersistedGlobalId(globalId);
        return lookup.persisted() ? lookup.getPrimaryKey() : this.insert(globalId);
    }

    public long getOrInsertClass(GlobalId globalId) {
        Class cdoClass = globalId.getCdoClass().getClientsClass();
        Optional<Long> lookup = this.findClassPk(cdoClass);
        return lookup.isPresent() ? ((Long)lookup.get()).longValue() : this.insertClass(cdoClass);
    }

    private Optional<Long> findGlobalIdPk(GlobalId globalId) {
        SelectQuery query = this.polyJdbc.query().select("global_id_pk").from("jv_global_id as g INNER JOIN jv_cdo_class as c ON cdo_class_pk = cdo_class_fk").where("g.local_id = :localId AND c.qualified_name = :qualifiedName ").withArgument("localId", (Object)this.jsonConverter.toJson(globalId.getCdoId())).withArgument("qualifiedName", (Object)globalId.getCdoClass().getName());
        return PolyUtil.queryForOptionalLong(query, this.polyJdbc);
    }

    private long insert(GlobalId globalId) {
        long classPk = this.getOrInsertClass(globalId);
        InsertQuery insertGlobalIdQuery = this.polyJdbc.query().insert().into("jv_global_id").value("local_id", (Object)this.jsonConverter.toJson(globalId.getCdoId())).value("cdo_class_fk", (Object)classPk).sequence("global_id_pk", "jv_global_id_pk_seq");
        long globalIdPk = this.polyJdbc.queryRunner().insert(insertGlobalIdQuery);
        return globalIdPk;
    }

    private Optional<Long> findClassPk(Class<?> cdoClass) {
        SelectQuery query = this.polyJdbc.query().select("cdo_class_pk").from("jv_cdo_class").where("qualified_name = :qualifiedName ").withArgument("qualifiedName", (Object)cdoClass.getName());
        return PolyUtil.queryForOptionalLong(query, this.polyJdbc);
    }

    private long insertClass(Class<?> cdoClass) {
        InsertQuery query = this.polyJdbc.query().insert().into("jv_cdo_class").value("qualified_name", (Object)cdoClass.getName()).sequence("cdo_class_pk", "jv_cdo_class_pk_seq");
        return this.polyJdbc.queryRunner().insert(query);
    }

    public void setJsonConverter(JsonConverter JSONConverter) {
        this.jsonConverter = JSONConverter;
    }
}

