/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.javers.common.collections.Optional;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotBuilder;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.repository.sql.PolyUtil;
import org.javers.repository.sql.reposiotries.GlobalIdRepository;
import org.javers.repository.sql.reposiotries.PersistentGlobalId;
import org.joda.time.LocalDateTime;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.Order;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.query.mapper.ObjectMapper;

public class CdoSnapshotFinder {
    private final PolyJDBC polyJDBC;
    private JsonConverter jsonConverter;
    private GlobalIdRepository globalIdRepository;

    public CdoSnapshotFinder(GlobalIdRepository globalIdRepository, PolyJDBC polyJDBC) {
        this.globalIdRepository = globalIdRepository;
        this.polyJDBC = polyJDBC;
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        PersistentGlobalId persistentGlobalId = this.globalIdRepository.findPersistedGlobalId(globalId);
        if (!persistentGlobalId.persisted()) {
            return Optional.empty();
        }
        Optional<Long> maxSnapshot = this.selectMaxSnapshotPrimaryKey(persistentGlobalId);
        if (maxSnapshot.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Object)this.getCdoSnapshotsBySnapshotPk((Long)maxSnapshot.get(), (Long)maxSnapshot.get(), persistentGlobalId).get(0));
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, int limit) {
        PersistentGlobalId persistentGlobalId = this.globalIdRepository.findPersistedGlobalId(globalId);
        if (!persistentGlobalId.persisted()) {
            return Collections.emptyList();
        }
        List<Long> latestSnapshots = this.selectLatestSnapshotPrimaryKeys(persistentGlobalId, limit);
        if (latestSnapshots.isEmpty()) {
            return Collections.emptyList();
        }
        long maxSnapshotPk = latestSnapshots.get(0);
        long minSnapshotPk = latestSnapshots.get(latestSnapshots.size() - 1);
        return this.getCdoSnapshotsBySnapshotPk(minSnapshotPk, maxSnapshotPk, persistentGlobalId);
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    private List<CdoSnapshot> getCdoSnapshotsBySnapshotPk(long minSnapshotPk, long maxSnapshotPk, final PersistentGlobalId globalId) {
        SelectQuery query = this.polyJDBC.query().select("state, type, author, commit_date, commit_id").from("jv_snapshot INNER JOIN jv_commit  ON commit_pk = commit_fk").where("snapshot_pk between :minSnapshotPk and :maxSnapshotPk AND global_id_fk = :globalIdPk").orderBy("snapshot_pk", Order.DESC).withArgument("globalIdPk", (Object)globalId.getPrimaryKey()).withArgument("minSnapshotPk", (Object)minSnapshotPk).withArgument("maxSnapshotPk", (Object)maxSnapshotPk);
        return this.polyJDBC.queryRunner().queryList(query, (ObjectMapper)new ObjectMapper<CdoSnapshot>(){

            public CdoSnapshot createObject(ResultSet resultSet) throws SQLException {
                String author = resultSet.getString("author");
                LocalDateTime commitDate = new LocalDateTime((Object)resultSet.getTimestamp("commit_date"));
                CommitId commitId = CommitId.valueOf((String)resultSet.getString("commit_id"));
                CommitMetadata commit = new CommitMetadata(author, commitDate, commitId);
                SnapshotType snapshotType = SnapshotType.valueOf((String)resultSet.getString("type"));
                CdoSnapshotState state = CdoSnapshotFinder.this.jsonConverter.snapshotStateFromJson(resultSet.getString("state"), (GlobalId)globalId);
                CdoSnapshotBuilder builder = CdoSnapshotBuilder.cdoSnapshot((GlobalId)globalId, (CommitMetadata)commit);
                builder.withType(snapshotType);
                return builder.withState(state).build();
            }
        });
    }

    private List<Long> selectLatestSnapshotPrimaryKeys(PersistentGlobalId globalId, int limit) {
        SelectQuery query = this.polyJDBC.query().select("snapshot_pk").from("jv_snapshot").where("global_id_fk = :globalIdPk").withArgument("globalIdPk", (Object)globalId.getPrimaryKey()).orderBy("snapshot_pk", Order.DESC).limit(limit);
        return PolyUtil.queryForLongList(query, this.polyJDBC);
    }

    private Optional<Long> selectMaxSnapshotPrimaryKey(PersistentGlobalId globalId) {
        SelectQuery query = this.polyJDBC.query().select("MAX(snapshot_pk)").from("jv_snapshot").where("global_id_fk = :globalIdPk").withArgument("globalIdPk", (Object)globalId.getPrimaryKey());
        Optional<Long> result = PolyUtil.queryForOptionalLong(query, this.polyJDBC);
        if (result.isPresent() && (Long)result.get() == 0L) {
            return Optional.empty();
        }
        return result;
    }
}

