/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.redis;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.SerializationUtils;
import org.javers.common.collections.Lists;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.redis.CdoSnapshotKeyExpireListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.params.ZRangeParams;
import redis.clients.jedis.util.Pool;

public class JaversRedisRepository
implements JaversRepository {
    private static final Logger log = LoggerFactory.getLogger(JaversRedisRepository.class);
    public static final String JV_SNAPSHOTS = "jv_snapshots:";
    public static final String JV_SNAPSHOTS_ENTITY_KEYS = "jv_snapshots_keys";
    public static final String JV_SNAPSHOTS_ENTITY_KEYS_SET = "jv_snapshots_keys_set";
    private static final byte[] JV_HEAD_ID = "jv_head_id".getBytes();
    private JsonConverter jsonConverter;
    private final Pool<Jedis> jedisPool;
    private final long duration;
    private final ExecutorService executor;

    public JaversRedisRepository(JedisPool jedisPool, Duration duration) {
        this.jedisPool = jedisPool;
        this.duration = duration.toSeconds();
        this.executor = Executors.newSingleThreadExecutor();
        this.initializeSubscriber();
    }

    public JaversRedisRepository(JedisSentinelPool jedisSentinelPool, Duration duration) {
        this.jedisPool = jedisSentinelPool;
        this.duration = duration.toSeconds();
        this.executor = Executors.newSingleThreadExecutor();
        this.initializeSubscriber();
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public CommitId getHeadId() {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            byte[] headIdByteArray = jedis.get(JV_HEAD_ID);
            CommitId commitId = (CommitId)Optional.ofNullable(headIdByteArray).map(a -> SerializationUtils.deserialize((byte[])a)).orElse(new CommitId(0L, 0));
            return commitId;
        }
    }

    public void persist(Commit commit) {
        Validate.conditionFulfilled((boolean)Objects.nonNull(this.jsonConverter), (String)"jsonConverter is null");
        Validate.argumentsAreNotNull((Object[])new Object[]{commit});
        commit.getSnapshots().forEach(this::persist);
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.set(JV_HEAD_ID, SerializationUtils.serialize((Serializable)commit.getId()));
        }
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        String key = this.key(globalId);
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List cdoSnapshotJson = jedis.lrange(key, 0L, 1L);
            Optional<CdoSnapshot> optional = cdoSnapshotJson.stream().findFirst().map(v -> (CdoSnapshot)this.jsonConverter.fromJson(v, CdoSnapshot.class));
            return optional;
        }
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            if (queryParams.isAggregate()) {
                String entityKey = this.key(globalId);
                String setKey = JV_SNAPSHOTS_ENTITY_KEYS.concat(":").concat(globalId.getTypeName());
                List<String> keys = jedis.zrange(setKey, 0L, -1L).stream().filter(v -> v.startsWith(entityKey)).toList();
                List<CdoSnapshot> list = keys.stream().map(key -> this.getStateHistory((String)key, queryParams)).flatMap(Collection::stream).sorted(this.inReverseChronologicalOrder()).toList();
                return list;
            }
            String key2 = this.key(globalId);
            List<CdoSnapshot> list = this.getStateHistory(key2, queryParams);
            return list;
        }
    }

    public List<CdoSnapshot> getStateHistory(Set<ManagedType> givenClasses, QueryParams queryParams) {
        Validate.argumentsAreNotNull((Object[])new Object[]{givenClasses, queryParams});
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            ArrayList<CdoSnapshot> result = new ArrayList<CdoSnapshot>();
            for (ManagedType givenClass : givenClasses) {
                if (givenClass instanceof ValueObjectType) {
                    List<CdoSnapshot> snapshotsF = this.getSnapshots(queryParams);
                    List<CdoSnapshot> snapshots = snapshotsF.stream().filter(snapshot -> snapshot.getManagedType().getName().equals(givenClass.getName())).toList();
                    result.addAll(snapshots);
                    continue;
                }
                String setKey = "jv_snapshots_keys:" + givenClass.getName();
                int start = queryParams.skip();
                int stop = queryParams.limit() - 1;
                List range = jedis.zrange(setKey, (long)start, (long)stop);
                System.out.println("Range for " + setKey + ": " + String.valueOf(range));
                for (String key : range) {
                    if (key.contains("#")) continue;
                    InstanceId instanceId = this.instanceId(key);
                    List<CdoSnapshot> stateHistory = this.getStateHistory((GlobalId)instanceId, queryParams);
                    result.addAll(stateHistory);
                }
            }
            result.sort(this.inReverseChronologicalOrder());
            List<CdoSnapshot> list = this.applyQueryParams(result, queryParams);
            return list;
        }
    }

    public List<CdoSnapshot> getValueObjectStateHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        Validate.argumentsAreNotNull((Object[])new Object[]{ownerEntity, path, queryParams});
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String setKey = JV_SNAPSHOTS_ENTITY_KEYS.concat(":").concat(ownerEntity.getName());
            int start = queryParams.skip();
            int stop = queryParams.limit() - 1;
            List entityKeys = jedis.zrange(setKey, (long)start, (long)stop);
            List<String> valueObjectKeys = entityKeys.stream().filter(k -> k.contains("#".concat(path))).toList();
            List<CdoSnapshot> result = valueObjectKeys.stream().map(key -> this.getStateHistory((String)key, queryParams)).flatMap(Collection::stream).sorted(this.inReverseChronologicalOrder()).toList();
            List<CdoSnapshot> list = this.applyQueryParams(result, queryParams);
            return list;
        }
    }

    public List<CdoSnapshot> getSnapshots(QueryParams queryParams) {
        Validate.argumentIsNotNull((Object)queryParams);
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List keys = jedis.zrange(JV_SNAPSHOTS_ENTITY_KEYS, 0L, -1L);
            List<CdoSnapshot> allCdoSnapshots = keys.stream().map(this::instanceId).map(instanceId -> this.getStateHistory((GlobalId)instanceId, queryParams)).flatMap(Collection::stream).skip(queryParams.skip()).toList();
            List<CdoSnapshot> list = this.applyQueryParams(allCdoSnapshots, queryParams);
            return list;
        }
    }

    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List<CdoSnapshot> list = snapshotIdentifiers.stream().map(snapshotIdentifier -> {
                String key = this.key((SnapshotIdentifier)snapshotIdentifier);
                long size = jedis.llen(key);
                long index = size - snapshotIdentifier.getVersion();
                return Optional.ofNullable(jedis.lrange(key, index, index)).orElse(Collections.emptyList()).stream().map(v -> (CdoSnapshot)this.jsonConverter.fromJson(v, CdoSnapshot.class)).findFirst();
            }).filter(Optional::isPresent).map(Optional::get).toList();
            return list;
        }
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    public void ensureSchema() {
    }

    public long cleanExpiredSnapshotsKeysSets() {
        long l;
        block8: {
            Jedis jedis = (Jedis)this.jedisPool.getResource();
            try {
                Set snapshotKeys = jedis.keys(JV_SNAPSHOTS.concat("*"));
                List expiredSnapshotKeys = jedis.zrange(JV_SNAPSHOTS_ENTITY_KEYS, ZRangeParams.zrangeParams((int)0, (int)-1));
                expiredSnapshotKeys.removeAll(snapshotKeys);
                log.debug("expired snapshot keys: {}", (Object)expiredSnapshotKeys.size());
                expiredSnapshotKeys.forEach(expiredSnapshotKey -> {
                    jedis.zrem(JV_SNAPSHOTS_ENTITY_KEYS, new String[]{expiredSnapshotKey});
                    log.debug("{} removed from jv_snapshots_keys", expiredSnapshotKey);
                    String entitySnapshotKeysSet = expiredSnapshotKey.substring(0, expiredSnapshotKey.indexOf(47)).replace("jv_snapshots", JV_SNAPSHOTS_ENTITY_KEYS);
                    jedis.zrem(entitySnapshotKeysSet, new String[]{expiredSnapshotKey});
                    log.debug("{} removed from {}", expiredSnapshotKey, (Object)entitySnapshotKeysSet);
                });
                l = expiredSnapshotKeys.size();
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    return 0L;
                }
            }
            jedis.close();
        }
        return l;
    }

    private void initializeSubscriber() {
        this.executor.execute(() -> {
            try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
                jedis.psubscribe((JedisPubSub)new CdoSnapshotKeyExpireListener(this.jedisPool), new String[]{"__key*__:jv_snapshots:*"});
            }
            catch (Exception e) {
                log.warn("Redis subscription failed: {}", (Object)e.getMessage());
            }
        });
    }

    private void persist(CdoSnapshot snapshot) {
        String key = this.key(snapshot);
        String value = this.jsonConverter.toJson((Object)snapshot);
        String entityNameKey = JV_SNAPSHOTS_ENTITY_KEYS.concat(":").concat(snapshot.getGlobalId().getTypeName());
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            GlobalId globalId;
            double commitInstantMs = -snapshot.getCommitMetadata().getCommitDateInstant().toEpochMilli();
            jedis.zadd(JV_SNAPSHOTS_ENTITY_KEYS, commitInstantMs, key);
            if (snapshot.getGlobalId() instanceof InstanceId || snapshot.getGlobalId() instanceof UnboundedValueObjectId) {
                jedis.zadd(entityNameKey, commitInstantMs, key);
                String entityTypeName = snapshot.getGlobalId().getTypeName();
                jedis.zadd(JV_SNAPSHOTS_ENTITY_KEYS_SET, 0.0, JV_SNAPSHOTS_ENTITY_KEYS.concat(":").concat(entityTypeName));
            }
            if ((globalId = snapshot.getGlobalId()) instanceof ValueObjectId) {
                ValueObjectId valueObjectId = (ValueObjectId)globalId;
                GlobalId ownerId = valueObjectId.getOwnerId();
                String ownerEntityNameKey = JV_SNAPSHOTS_ENTITY_KEYS.concat(":").concat(ownerId.getTypeName());
                jedis.zadd(ownerEntityNameKey, commitInstantMs, key);
            }
            jedis.lpush(key, new String[]{value});
            jedis.expire(key, this.duration);
        }
    }

    private String key(CdoSnapshot snapshot) {
        return this.key(snapshot.getGlobalId());
    }

    private String key(SnapshotIdentifier snapshotIdentifier) {
        return this.key(snapshotIdentifier.getGlobalId());
    }

    private String key(GlobalId globalId) {
        return JV_SNAPSHOTS.concat(globalId.value());
    }

    private List<CdoSnapshot> getStateHistory(String key, QueryParams queryParams) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List cdoSnapshotJsonList = jedis.lrange(key, 0L, -1L);
            List<CdoSnapshot> cdoSnapshots = cdoSnapshotJsonList.stream().map(cdoSnapshotJson -> (CdoSnapshot)this.jsonConverter.fromJson(cdoSnapshotJson, CdoSnapshot.class)).toList();
            List<CdoSnapshot> filteredCdoSnapshots = this.applyQueryParams(cdoSnapshots, queryParams);
            List<CdoSnapshot> list = this.trimResultsToRequestedSlice(filteredCdoSnapshots, queryParams);
            return list;
        }
    }

    private List<CdoSnapshot> applyQueryParams(List<CdoSnapshot> snapshots, QueryParams queryParams) {
        if (!queryParams.commitIds().isEmpty()) {
            snapshots = this.filterSnapshotsByCommitIds(snapshots, queryParams.commitIds());
        }
        if (queryParams.toCommitId().isPresent()) {
            snapshots = this.filterSnapshotsByToCommitId(snapshots, (CommitId)queryParams.toCommitId().get());
        }
        if (queryParams.version().isPresent()) {
            snapshots = Lists.positiveFilter(snapshots, snapshot -> snapshot.getVersion() == ((Long)queryParams.version().get()).longValue());
        }
        if (queryParams.fromVersion().isPresent()) {
            snapshots = Lists.positiveFilter((List)snapshots, snapshot -> snapshot.getVersion() >= (Long)queryParams.fromVersion().get());
        }
        if (queryParams.toVersion().isPresent()) {
            snapshots = Lists.positiveFilter((List)snapshots, snapshot -> snapshot.getVersion() <= (Long)queryParams.toVersion().get());
        }
        if (queryParams.author().isPresent()) {
            snapshots = this.filterSnapshotsByAuthor(snapshots, (String)queryParams.author().get());
        }
        if (queryParams.authorLikeIgnoreCase().isPresent()) {
            snapshots = this.filterSnapshotsByAuthorLikeIgnoreCase(snapshots, (String)queryParams.authorLikeIgnoreCase().get());
        }
        if (this.hasDates(queryParams)) {
            snapshots = this.filterSnapshotsByCommitDate(snapshots, queryParams);
        }
        if (this.hasInstants(queryParams)) {
            snapshots = this.filterSnapshotsByCommitDateInstant(snapshots, queryParams);
        }
        if (!queryParams.changedProperties().isEmpty()) {
            snapshots = this.filterByPropertyNames(snapshots, queryParams.changedProperties());
        }
        if (queryParams.snapshotType().isPresent()) {
            snapshots = Lists.positiveFilter(snapshots, snapshot -> snapshot.getType() == queryParams.snapshotType().get());
        }
        snapshots = this.filterSnapshotsByCommitProperties(snapshots, queryParams.commitProperties());
        snapshots = this.filterSnapshotsByCommitPropertiesLike(snapshots, queryParams.commitPropertiesLike());
        return snapshots;
    }

    private List<CdoSnapshot> filterByPropertyNames(List<CdoSnapshot> snapshots, Set<String> propertyNames) {
        return Lists.positiveFilter(snapshots, input -> propertyNames.stream().anyMatch(arg_0 -> ((CdoSnapshot)input).hasChangeAt(arg_0)));
    }

    private List<CdoSnapshot> filterSnapshotsByToCommitId(List<CdoSnapshot> snapshots, CommitId commitId) {
        return Lists.positiveFilter(snapshots, snapshot -> snapshot.getCommitMetadata().getId().isBeforeOrEqual(commitId));
    }

    private List<CdoSnapshot> filterSnapshotsByCommitIds(List<CdoSnapshot> snapshots, Set<CommitId> commitIds) {
        return Lists.positiveFilter(snapshots, snapshot -> commitIds.contains(snapshot.getCommitId()));
    }

    private List<CdoSnapshot> filterSnapshotsByAuthor(List<CdoSnapshot> snapshots, String author) {
        return Lists.positiveFilter(snapshots, snapshot -> author.equals(snapshot.getCommitMetadata().getAuthor()));
    }

    private List<CdoSnapshot> filterSnapshotsByAuthorLikeIgnoreCase(List<CdoSnapshot> snapshots, String author) {
        return Lists.positiveFilter(snapshots, snapshot -> snapshot.getCommitMetadata().getAuthor().toLowerCase(Locale.ROOT).contains(author.toLowerCase(Locale.ROOT)));
    }

    private List<CdoSnapshot> filterSnapshotsByCommitDate(List<CdoSnapshot> snapshots, QueryParams queryParams) {
        return Lists.positiveFilter(snapshots, snapshot -> this.isDateInRange(queryParams, snapshot.getCommitMetadata().getCommitDate()));
    }

    public boolean isDateInRange(QueryParams q, LocalDateTime date) {
        if (q.from().map(from -> from.isAfter(date)).orElse(false).booleanValue()) {
            return false;
        }
        return q.to().map(to -> to.isBefore(date)).orElse(false) == false;
    }

    private List<CdoSnapshot> filterSnapshotsByCommitDateInstant(List<CdoSnapshot> snapshots, QueryParams queryParams) {
        return Lists.positiveFilter(snapshots, snapshot -> this.isInstantInRange(queryParams, snapshot.getCommitMetadata().getCommitDateInstant()));
    }

    private boolean isInstantInRange(QueryParams q, Instant instant) {
        if (q.fromInstant().map(from -> from.isAfter(instant)).orElse(false).booleanValue()) {
            return false;
        }
        return q.toInstant().map(to -> to.isBefore(instant)).orElse(false) == false;
    }

    private List<CdoSnapshot> filterSnapshotsByCommitProperties(List<CdoSnapshot> snapshots, Map<String, Collection<String>> commitProperties) {
        return Lists.positiveFilter(snapshots, snapshot -> commitProperties.entrySet().stream().allMatch(commitProperty -> {
            Map actualCommitProperties = snapshot.getCommitMetadata().getProperties();
            return actualCommitProperties.containsKey(commitProperty.getKey()) && ((Collection)commitProperty.getValue()).contains(actualCommitProperties.get(commitProperty.getKey()));
        }));
    }

    private List<CdoSnapshot> filterSnapshotsByCommitPropertiesLike(List<CdoSnapshot> snapshots, Map<String, String> commitPropertiesLike) {
        return Lists.positiveFilter(snapshots, snapshot -> commitPropertiesLike.entrySet().stream().allMatch(commitProperty -> {
            Map actualCommitProperties = snapshot.getCommitMetadata().getProperties();
            return actualCommitProperties.containsKey(commitProperty.getKey()) && ((String)actualCommitProperties.get(commitProperty.getKey())).toLowerCase(Locale.ROOT).contains(((String)commitProperty.getValue()).toLowerCase(Locale.ROOT));
        }));
    }

    private boolean hasDates(QueryParams q) {
        return q.from().isPresent() || q.to().isPresent();
    }

    public boolean hasInstants(QueryParams q) {
        return q.fromInstant().isPresent() || q.toInstant().isPresent();
    }

    private InstanceId instanceId(String key) {
        int index = key.indexOf("/");
        String typeName = key.substring(13, index);
        String codId = key.substring(index + 1);
        return new InstanceId(typeName, (Object)codId, codId);
    }

    private Comparator<? super CdoSnapshot> inReverseChronologicalOrder() {
        return (s1, s2) -> Long.compare(s2.getCommitId().getMajorId(), s1.getCommitId().getMajorId());
    }

    private List<CdoSnapshot> trimResultsToRequestedSlice(List<CdoSnapshot> snapshots, QueryParams queryParams) {
        int start = Math.min(queryParams.skip(), snapshots.size());
        int stop = Math.min(queryParams.skip() + queryParams.limit(), snapshots.size());
        return new ArrayList<CdoSnapshot>(snapshots.subList(start, stop));
    }
}

