/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.mongo;

import org.bson.Document;

class MapKeyDotReplacer {
    private static final String REPLACEMENT = "#dot#";

    MapKeyDotReplacer() {
    }

    Document replaceInSnapshotState(Document snapshot) {
        return this.replaceInPropertyMaps(snapshot, "\\.", ".", REPLACEMENT);
    }

    Document back(Document snapshot) {
        return this.replaceInPropertyMaps(snapshot, REPLACEMENT, REPLACEMENT, ".");
    }

    private Document replaceInPropertyMaps(Document snapshot, String regexFrom, String from, String to) {
        Document state = this.getState(snapshot);
        for (String pName : state.keySet()) {
            if (!(state.get((Object)pName) instanceof Document)) continue;
            Document mapProperty = (Document)state.get((Object)pName);
            state.put(pName, (Object)this.replaceInMapKeys(mapProperty, regexFrom, from, to));
        }
        return snapshot;
    }

    private Document getState(Document snapshot) {
        return (Document)snapshot.get((Object)"state");
    }

    private Document replaceInMapKeys(Document map, String regexFrom, String from, String to) {
        for (String key : map.keySet()) {
            if (!key.contains(from)) continue;
            String escaped = key.replaceAll(regexFrom, to);
            Object val = map.get((Object)key);
            map.remove((Object)key);
            map.put(escaped, val);
        }
        return map;
    }
}

