/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.clazz.Entity;
import org.javers.core.metamodel.clazz.ManagedClass;
import org.javers.core.metamodel.clazz.ValueObject;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.mongo.model.MongoHeadId;

public class MongoRepository
implements JaversRepository {
    private static final int DESC = -1;
    private static final int ASC = 1;
    public static final String SNAPSHOTS = "jv_snapshots";
    public static final String COMMIT_ID = "commitMetadata.id";
    public static final String GLOBAL_ID_KEY = "globalId_key";
    public static final String GLOBAL_ID_ENTITY = "globalId.entity";
    public static final String GLOBAL_ID_OWNER_ID_ENTITY = "globalId.ownerId.entity";
    public static final String GLOBAL_ID_FRAGMENT = "globalId.fragment";
    public static final String GLOBAL_ID_VALUE_OBJECT = "globalId.valueObject";
    public static final String CHANGED_PROPERTIES = "changedProperties";
    private DB mongo;
    private JsonConverter jsonConverter;

    public MongoRepository(DB mongo) {
        this.mongo = mongo;
    }

    MongoRepository(DB mongo, JsonConverter jsonConverter) {
        this.mongo = mongo;
        this.jsonConverter = jsonConverter;
    }

    public void persist(Commit commit) {
        this.persistSnapshots(commit);
        this.persistHeadId(commit);
    }

    void clean() {
        this.snapshotsCollection().remove((DBObject)new BasicDBObject());
        this.headCollection().remove((DBObject)new BasicDBObject());
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, int limit) {
        return this.queryForSnapshots((DBObject)this.createIdQuery(globalId), limit);
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        return this.getLatest((DBObject)this.createIdQuery(globalId));
    }

    public List<CdoSnapshot> getValueObjectStateHistory(Entity ownerEntity, String path, int limit) {
        BasicDBObject query = new BasicDBObject(GLOBAL_ID_OWNER_ID_ENTITY, (Object)ownerEntity.getClientsClass().getName());
        query.append(GLOBAL_ID_FRAGMENT, (Object)path);
        return this.queryForSnapshots((DBObject)query, limit);
    }

    public List<CdoSnapshot> getPropertyStateHistory(GlobalId globalId, String propertyName, int limit) {
        BasicDBObject query = this.createIdQuery(globalId);
        query.append(CHANGED_PROPERTIES, (Object)propertyName);
        return this.queryForSnapshots((DBObject)query, limit);
    }

    public List<CdoSnapshot> getPropertyStateHistory(ManagedClass givenClass, String propertyName, int limit) {
        BasicDBObject query = this.createGlobalIdClassQuery(givenClass);
        query.append(CHANGED_PROPERTIES, (Object)propertyName);
        return this.queryForSnapshots((DBObject)query, limit);
    }

    public List<CdoSnapshot> getStateHistory(ManagedClass givenClass, int limit) {
        BasicDBObject query = this.createGlobalIdClassQuery(givenClass);
        return this.queryForSnapshots((DBObject)query, limit);
    }

    public CommitId getHeadId() {
        DBObject headId = this.headCollection().findOne();
        if (headId == null) {
            return null;
        }
        return (CommitId)this.jsonConverter.fromJson(headId.get("id").toString(), CommitId.class);
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    public void ensureSchema() {
        Object stringCommitId;
        DBCollection snapshots = this.snapshotsCollection();
        snapshots.createIndex((DBObject)new BasicDBObject(GLOBAL_ID_KEY, (Object)1));
        snapshots.createIndex((DBObject)new BasicDBObject(GLOBAL_ID_ENTITY, (Object)1));
        snapshots.createIndex((DBObject)new BasicDBObject(GLOBAL_ID_VALUE_OBJECT, (Object)1));
        snapshots.createIndex((DBObject)new BasicDBObject(GLOBAL_ID_OWNER_ID_ENTITY, (Object)1));
        snapshots.createIndex((DBObject)new BasicDBObject(CHANGED_PROPERTIES, (Object)1));
        this.headCollection();
        DBObject doc = snapshots.findOne();
        if (doc != null && (stringCommitId = ((Map)doc.get("commitMetadata")).get("id")) instanceof String) {
            this.mongo.eval("db.jv_snapshots.find().forEach(function(snapshot){snapshot.commitMetadata.id = Number(snapshot.commitMetadata.id);db.jv_snapshots.save(snapshot);});", new Object[0]);
        }
    }

    private BasicDBObject createIdQuery(GlobalId id) {
        return new BasicDBObject(GLOBAL_ID_KEY, (Object)id.value());
    }

    private BasicDBObject createGlobalIdClassQuery(ManagedClass givenClass) {
        String cName = givenClass.getClientsClass().getName();
        BasicDBObject query = null;
        if (givenClass instanceof Entity) {
            query = new BasicDBObject(GLOBAL_ID_ENTITY, (Object)cName);
        }
        if (givenClass instanceof ValueObject) {
            query = new BasicDBObject(GLOBAL_ID_VALUE_OBJECT, (Object)cName);
        }
        return query;
    }

    private CdoSnapshot readFromDBObject(DBObject dbObject) {
        return (CdoSnapshot)this.jsonConverter.fromJson(dbObject.toString(), CdoSnapshot.class);
    }

    private DBObject writeToDBObject(CdoSnapshot snapshot) {
        Validate.conditionFulfilled((this.jsonConverter != null ? 1 : 0) != 0, (String)"MongoRepository: jsonConverter is null");
        BasicDBObject dbObject = (BasicDBObject)JSON.parse((String)this.jsonConverter.toJson((Object)snapshot));
        dbObject.append(GLOBAL_ID_KEY, (Object)snapshot.getGlobalId().value());
        return dbObject;
    }

    private DBCollection snapshotsCollection() {
        return this.mongo.getCollection(SNAPSHOTS);
    }

    private DBCollection headCollection() {
        return this.mongo.getCollection("jv_head_id");
    }

    private void persistSnapshots(Commit commit) {
        DBCollection collection = this.snapshotsCollection();
        for (CdoSnapshot snapshot : commit.getSnapshots()) {
            collection.save(this.writeToDBObject(snapshot));
        }
    }

    private void persistHeadId(Commit commit) {
        DBCollection headIdCollection = this.headCollection();
        DBObject oldHeadId = headIdCollection.findOne();
        MongoHeadId newHeadId = new MongoHeadId(this.jsonConverter.toJson((Object)commit.getId()));
        if (oldHeadId == null) {
            headIdCollection.save((DBObject)newHeadId);
        } else {
            headIdCollection.findAndModify(oldHeadId, (DBObject)newHeadId);
        }
    }

    private DBCursor getMongoSnapshotsCoursor(DBObject idQuery, int limit) {
        return this.snapshotsCollection().find(idQuery).sort((DBObject)new BasicDBObject(COMMIT_ID, (Object)-1)).limit(limit);
    }

    private Optional<CdoSnapshot> getLatest(DBObject idQuery) {
        DBCursor mongoLatest = this.getMongoSnapshotsCoursor(idQuery, 1);
        if (mongoLatest.size() == 0) {
            return Optional.empty();
        }
        DBObject dbObject = (DBObject)mongoLatest.iterator().next();
        return Optional.of((Object)this.readFromDBObject(dbObject));
    }

    private List<CdoSnapshot> queryForSnapshots(DBObject query, int limit) {
        DBCursor mongoSnapshots = this.getMongoSnapshotsCoursor(query, limit);
        Iterator iterator = mongoSnapshots.iterator();
        ArrayList<CdoSnapshot> snapshots = new ArrayList<CdoSnapshot>();
        while (iterator.hasNext()) {
            DBObject dbObject = (DBObject)iterator.next();
            snapshots.add(this.readFromDBObject(dbObject));
        }
        return snapshots;
    }
}

