/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jdbc;

import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.javers.common.validation.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceFactory.class);

    public static DataSource createDBCP(String driverClassName, String url, String username, String password) {
        Validate.argumentIsNotNull((Object)driverClassName);
        Validate.argumentIsNotNull((Object)url);
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(driverClassName);
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        dataSource.setDefaultAutoCommit(false);
        logger.info("creating ConnectionPool for database " + url);
        return dataSource;
    }
}

