/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jdbc;

import java.util.Arrays;
import org.javers.core.AbstractJaversBuilder;
import org.javers.repository.jdbc.DialectName;
import org.javers.repository.jdbc.JdbcDiffRepository;
import org.javers.repository.jdbc.JdbcRepositoryConfiguration;
import org.javers.repository.jdbc.pico.JdbcJaversModule;
import org.javers.repository.jdbc.schema.JaversSchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDiffRepositoryBuilder
extends AbstractJaversBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JdbcDiffRepositoryBuilder.class);
    private JdbcRepositoryConfiguration jdbcConfiguration = new JdbcRepositoryConfiguration();

    private JdbcDiffRepositoryBuilder() {
    }

    public static JdbcDiffRepositoryBuilder jdbcDiffRepository() {
        return new JdbcDiffRepositoryBuilder();
    }

    public JdbcDiffRepositoryBuilder configure(String classpathName) {
        this.jdbcConfiguration.readProperties(classpathName);
        return this;
    }

    public JdbcDiffRepositoryBuilder withDialect(DialectName dialect) {
        this.jdbcConfiguration.withDialect(dialect);
        return this;
    }

    public JdbcDiffRepositoryBuilder withDatabaseUrl(String databaseUrl) {
        this.jdbcConfiguration.withDatabaseUrl(databaseUrl);
        return this;
    }

    public JdbcDiffRepositoryBuilder withUsername(String username) {
        this.jdbcConfiguration.withUsername(username);
        return this;
    }

    public JdbcDiffRepositoryBuilder withPassword(String password) {
        this.jdbcConfiguration.withPassword(password);
        return this;
    }

    public JdbcDiffRepository build() {
        logger.info("starting up JDBC repository module ...");
        this.bootContainer(new JdbcJaversModule(), Arrays.asList(this.jdbcConfiguration.createConnectionPool(), this.jdbcConfiguration.getPollyDialect()));
        this.createSchemaIfNotExists();
        return this.getContainerComponent(JdbcDiffRepository.class);
    }

    private void createSchemaIfNotExists() {
        JaversSchemaManager schemaManager = this.getContainerComponent(JaversSchemaManager.class);
        schemaManager.createSchemaIfNotExists();
    }

    protected <T> T getContainerComponent(Class<T> ofClass) {
        return (T)super.getContainerComponent(ofClass);
    }
}

