/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.List;
import java.util.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryCompiler;
import org.javers.repository.jql.VoOwnerFilter;

class SnapshotQueryRunner {
    private final QueryCompiler queryCompiler;
    private final GlobalIdFactory globalIdFactory;
    private final JaversExtendedRepository repository;

    SnapshotQueryRunner(QueryCompiler queryCompiler, GlobalIdFactory globalIdFactory, JaversExtendedRepository repository) {
        this.queryCompiler = queryCompiler;
        this.globalIdFactory = globalIdFactory;
        this.repository = repository;
    }

    Optional<CdoSnapshot> runQueryForLatestSnapshot(GlobalIdDTO globalId) {
        Validate.argumentIsNotNull(globalId);
        return this.repository.getLatest(this.globalIdFactory.createFromDto(globalId));
    }

    List<CdoSnapshot> queryForSnapshots(JqlQuery query) {
        List<CdoSnapshot> result;
        this.queryCompiler.compile(query);
        if (query.isAnyDomainObjectQuery()) {
            result = this.repository.getSnapshots(query.getQueryParams());
        } else if (query.isIdQuery()) {
            result = this.repository.getStateHistory(query.getIdFilter(), query.getQueryParams());
        } else if (query.isClassQuery()) {
            result = this.repository.getStateHistory(query.getClassFilter(), query.getQueryParams());
        } else if (query.isVoOwnerQuery()) {
            VoOwnerFilter filter = query.getVoOwnerFilter();
            result = this.repository.getValueObjectStateHistory(filter.getOwnerEntity(), filter.getPath(), query.getQueryParams());
        } else {
            throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "queryForSnapshots: " + String.valueOf(query) + " is not supported");
        }
        return result;
    }
}

