/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.javers.common.collections.Sets;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.EmptyGraph;
import org.javers.core.diff.NodeMatcher;
import org.javers.core.diff.NodePair;
import org.javers.core.graph.ObjectGraph;
import org.javers.core.graph.ObjectNode;

public class GraphPair {
    private final ObjectGraph leftGraph;
    private final ObjectGraph rightGraph;
    private final Collection<ObjectNode> onlyOnLeft;
    private final Collection<ObjectNode> onlyOnRight;
    private final Collection<NodePair> matching;
    private final Optional<CommitMetadata> commitMetadata;

    GraphPair(ObjectGraph leftGraph, ObjectGraph rightGraph) {
        this(leftGraph, rightGraph, Optional.empty());
    }

    public GraphPair(ObjectGraph leftGraph, ObjectGraph rightGraph, Optional<CommitMetadata> commitMetadata) {
        this.leftGraph = leftGraph;
        this.rightGraph = rightGraph;
        Function<ObjectNode, String> hasher = objectNode -> objectNode.getGlobalId().value();
        this.onlyOnLeft = Sets.difference(leftGraph.nodes(), rightGraph.nodes(), hasher);
        this.onlyOnRight = Sets.difference(rightGraph.nodes(), leftGraph.nodes(), hasher);
        this.commitMetadata = commitMetadata;
        this.matching = NodeMatcher.match(leftGraph.nodes(), rightGraph.nodes(), commitMetadata);
    }

    public GraphPair(ObjectGraph currentGraph) {
        this.leftGraph = new EmptyGraph();
        this.rightGraph = currentGraph;
        this.onlyOnLeft = Collections.emptySet();
        this.onlyOnRight = this.rightGraph.nodes();
        this.commitMetadata = Optional.empty();
        this.matching = Collections.emptyList();
    }

    public Collection<NodePair> getMatching() {
        return this.matching;
    }

    public Collection<ObjectNode> getOnlyOnLeft() {
        return this.onlyOnLeft;
    }

    public Collection<ObjectNode> getOnlyOnRight() {
        return this.onlyOnRight;
    }

    public Set<ObjectNode> getLeftNodeSet() {
        return this.leftGraph.nodes();
    }

    public Set<ObjectNode> getRightNodeSet() {
        return this.rightGraph.nodes();
    }

    public Optional<CommitMetadata> getCommitMetadata() {
        return this.commitMetadata;
    }
}

