/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.changelog;

import org.javers.common.string.PrettyValuePrinter;
import org.javers.core.changelog.AbstractTextChangeLog;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.changetype.NewObject;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.diff.changetype.ReferenceChange;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.diff.changetype.container.ArrayChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.diff.changetype.container.SetChange;
import org.javers.core.diff.changetype.map.MapChange;
import org.javers.core.metamodel.object.GlobalId;

public class SimpleTextChangeLog
extends AbstractTextChangeLog {
    @Override
    public void onCommit(CommitMetadata commitMetadata) {
        this.appendln("commit " + String.valueOf(commitMetadata.getId()) + ", author: " + commitMetadata.getAuthor() + ", " + PrettyValuePrinter.getDefault().format(commitMetadata.getCommitDate()));
    }

    @Override
    public void onAffectedObject(GlobalId globalId) {
        this.appendln("  changed object: " + globalId.value());
    }

    @Override
    public void onValueChange(ValueChange valueChange) {
        this.appendln("    value changed on '" + valueChange.getPropertyName() + "' property: '" + PrettyValuePrinter.getDefault().format(valueChange.getLeft()) + "' -> '" + PrettyValuePrinter.getDefault().format(valueChange.getRight()) + "'");
    }

    @Override
    public void onReferenceChange(ReferenceChange referenceChange) {
        this.appendln("    reference changed on '" + referenceChange.getPropertyName() + "' property: '" + String.valueOf(referenceChange.getLeft()) + "' -> '" + String.valueOf(referenceChange.getRight()) + "'");
    }

    @Override
    public void onNewObject(NewObject newObject) {
        this.appendln("    new object: " + String.valueOf(newObject.getAffectedGlobalId()));
    }

    @Override
    public void onObjectRemoved(ObjectRemoved objectRemoved) {
        this.appendln("    object removed: '" + String.valueOf(objectRemoved.getAffectedGlobalId()));
    }

    @Override
    public void onMapChange(MapChange mapChange) {
        this.appendln("    map changed on '" + mapChange.getPropertyName() + "' property: " + String.valueOf(mapChange.getEntryChanges()));
    }

    @Override
    public void onArrayChange(ArrayChange arrayChange) {
        this.appendln("    array changed on '" + arrayChange.getPropertyName() + "' property: " + String.valueOf(arrayChange.getChanges()));
    }

    @Override
    public void onListChange(ListChange listChange) {
        this.appendln("    list changed on '" + listChange.getPropertyName() + "' property: " + String.valueOf(listChange.getChanges()));
    }

    @Override
    public void onSetChange(SetChange setChange) {
        this.appendln("    set changed on '" + setChange.getPropertyName() + "' property: " + String.valueOf(setChange.getChanges()));
    }
}

