/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.exception.JaversException;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.ClassType;
import org.javers.core.metamodel.type.TypeMapperLazy;

public abstract class EnumerableType
extends ClassType {
    private final TypeMapperLazy typeMapperLazy;
    private final List<Type> concreteTypeArguments;

    EnumerableType(Type baseJavaType, int expectedArgs, TypeMapperLazy typeMapperLazy) {
        super(baseJavaType, Optional.empty(), expectedArgs);
        this.typeMapperLazy = typeMapperLazy;
        this.concreteTypeArguments = this.buildEnumerableConcreteTypeArguments(expectedArgs).map(Collections::unmodifiableList).orElse(null);
    }

    private Optional<List<Type>> buildEnumerableConcreteTypeArguments(int expectedArgs) {
        if (EnumerableType.isNonDefaultEnumerableTypeParameters(super.getConcreteClassTypeArguments(), expectedArgs)) {
            return Optional.empty();
        }
        Class enumerableClass = ((Supplier<Class>)() -> {
            try {
                return this.getEnumerableInterface();
            }
            catch (JaversException ex) {
                return null;
            }
        }).get();
        if (enumerableClass == null) {
            return Optional.empty();
        }
        Class baseJavaClass = this.getBaseJavaClass();
        if (baseJavaClass == enumerableClass) {
            return Optional.empty();
        }
        for (Class current = baseJavaClass; current != null && enumerableClass.isAssignableFrom(current); current = current.getSuperclass()) {
            List<Type> typeParameters;
            Type rawType;
            Type superClass = current.getGenericSuperclass();
            if (superClass instanceof ParameterizedType && (rawType = ((ParameterizedType)superClass).getRawType()) instanceof Class && enumerableClass.isAssignableFrom((Class)rawType) && EnumerableType.isNonDefaultEnumerableTypeParameters(typeParameters = EnumerableType.buildListOfConcreteTypeArguments(superClass, expectedArgs), expectedArgs)) {
                return Optional.of(typeParameters);
            }
            ArrayList<Type> interfaces = new ArrayList<Type>(Arrays.asList(current.getGenericInterfaces()));
            for (int i = 0; i < interfaces.size(); ++i) {
                List<Type> typeParameters2;
                Type rawType2;
                Type curInterface = interfaces.get(i);
                List<Type> superInterfaces = Arrays.asList(ReflectionUtil.extractClass(curInterface).getGenericInterfaces());
                interfaces.addAll(superInterfaces);
                if (!(curInterface instanceof ParameterizedType) || !((rawType2 = ((ParameterizedType)curInterface).getRawType()) instanceof Class) || !enumerableClass.isAssignableFrom((Class)rawType2) || !EnumerableType.isNonDefaultEnumerableTypeParameters(typeParameters2 = EnumerableType.buildListOfConcreteTypeArguments(curInterface, expectedArgs), expectedArgs)) continue;
                return Optional.of(typeParameters2);
            }
        }
        return Optional.empty();
    }

    private static boolean isNonDefaultEnumerableTypeParameters(List<Type> typeParameters, int expectedArgs) {
        return typeParameters != null && typeParameters.size() == expectedArgs && typeParameters.stream().anyMatch(it -> it != DEFAULT_TYPE_PARAMETER);
    }

    @Override
    public List<Type> getConcreteClassTypeArguments() {
        if (this.concreteTypeArguments == null) {
            return super.getConcreteClassTypeArguments();
        }
        return this.concreteTypeArguments;
    }

    @Override
    protected Object[] spawnConstructorArgs(Type baseJavaType) {
        return new Object[]{baseJavaType, this.getTypeMapperLazy()};
    }

    @Override
    protected Class[] spawnConstructorArgTypes() {
        return new Class[]{Type.class, TypeMapperLazy.class};
    }

    protected TypeMapperLazy getTypeMapperLazy() {
        return this.typeMapperLazy;
    }

    public abstract Object map(Object var1, EnumerableFunction var2, OwnerContext var3);

    public abstract Class<?> getEnumerableInterface();

    public Object map(Object sourceEnumerable, Function mapFunction) {
        return this.map(sourceEnumerable, mapFunction, false);
    }

    public Object mapPreservingSourceItemType(Object sourceEnumerable, Function mapFunction) {
        return this.map(sourceEnumerable, mapFunction);
    }

    public abstract Object map(Object var1, Function var2, boolean var3);

    public abstract boolean isEmpty(Object var1);

    public abstract Object empty();

    public <T> List<T> filterToList(Object source, Class<T> filter) {
        Validate.argumentsAreNotNull(filter);
        return Collections.unmodifiableList(this.items(source).filter(item -> item != null && filter.isAssignableFrom(item.getClass())).collect(Collectors.toList()));
    }

    protected abstract Stream<Object> items(Object var1);
}

