/*
 * Decompiled with CFR 0.152.
 */
package org.javers.shadow;

import java.util.HashSet;
import java.util.Set;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversProperty;

class ShadowBuilder {
    private final CdoSnapshot cdoSnapshot;
    private Object shadow;
    private Set<Wiring> wirings = new HashSet<Wiring>();

    ShadowBuilder(CdoSnapshot cdoSnapshot, Object shadow) {
        this.cdoSnapshot = cdoSnapshot;
        this.shadow = shadow;
    }

    void withStub(Object shadowStub) {
        this.shadow = shadowStub;
    }

    Object getShadow() {
        return this.shadow;
    }

    CdoSnapshot getCdoSnapshot() {
        return this.cdoSnapshot;
    }

    void addReferenceWiring(JaversProperty property, ShadowBuilder targetShadow) {
        this.wirings.add(new ReferenceWiring(property, targetShadow));
    }

    void addEnumerableWiring(JaversProperty property, Object targetWithShadows) {
        this.wirings.add(new EnumerableWiring(property, targetWithShadows));
    }

    void wire() {
        this.wirings.forEach(Wiring::wire);
    }

    private class ReferenceWiring
    extends Wiring {
        final ShadowBuilder target;

        ReferenceWiring(JaversProperty property, ShadowBuilder targetShadow) {
            super(property);
            this.target = targetShadow;
        }

        @Override
        void wire() {
            this.property.set(ShadowBuilder.this.shadow, this.target.shadow);
        }
    }

    private class EnumerableWiring
    extends Wiring {
        final Object targetWithShadows;

        EnumerableWiring(JaversProperty property, Object targetWithShadows) {
            super(property);
            this.targetWithShadows = targetWithShadows;
        }

        @Override
        void wire() {
            EnumerableType propertyType = (EnumerableType)this.property.getType();
            Object targetContainer = propertyType.mapPreservingSourceItemType(this.targetWithShadows, valueOrShadow -> {
                if (valueOrShadow instanceof ShadowBuilder) {
                    return ((ShadowBuilder)valueOrShadow).shadow;
                }
                return valueOrShadow;
            });
            this.property.set(ShadowBuilder.this.shadow, targetContainer);
        }
    }

    private abstract class Wiring {
        final JaversProperty property;

        Wiring(JaversProperty property) {
            this.property = property;
        }

        abstract void wire();
    }
}

