/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.core.diff.Change;
import org.javers.core.diff.changetype.NewObject;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.metamodel.object.GlobalId;

public final class ChangesByObject {
    private final List<Change> changes;
    private final GlobalId globalId;
    private final transient PrettyValuePrinter valuePrinter;

    ChangesByObject(GlobalId globalId, List<Change> changes, PrettyValuePrinter valuePrinter) {
        this.changes = changes;
        this.globalId = globalId;
        this.valuePrinter = valuePrinter;
    }

    public List<Change> get() {
        return Collections.unmodifiableList(this.changes);
    }

    public GlobalId getGlobalId() {
        return this.globalId;
    }

    public List<NewObject> getNewObjects() {
        return this.changes.stream().filter(c -> c instanceof NewObject).sorted(Comparator.comparingInt(it -> it.getAffectedGlobalId().value().length())).collect(Collectors.toList());
    }

    public List<ObjectRemoved> getObjectsRemoved() {
        return this.changes.stream().filter(c -> c instanceof ObjectRemoved).sorted(Comparator.comparingInt(it -> it.getAffectedGlobalId().value().length())).collect(Collectors.toList());
    }

    public List<PropertyChange> getPropertyChanges() {
        return this.changes.stream().filter(c -> c instanceof PropertyChange).sorted(Comparator.comparing(a -> ((PropertyChange)a).getPropertyNameWithPath())).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.getNewObjects().forEach(c -> b.append("* " + c.prettyPrint(this.valuePrinter) + "\n"));
        this.getObjectsRemoved().forEach(c -> b.append("* " + c.prettyPrint(this.valuePrinter) + "\n"));
        if (!this.getPropertyChanges().isEmpty() && this.getNewObjects().size() == 0 && this.getObjectsRemoved().size() == 0) {
            b.append("* changes on " + this.globalId.value() + " :\n");
        }
        this.getPropertyChanges().forEach(c -> b.append("  - " + c.prettyPrint(this.valuePrinter).replace("\n", "\n  ") + "\n"));
        return b.toString();
    }
}

