/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import org.javers.core.graph.Cdo;
import org.javers.core.graph.LiveCdo;
import org.javers.core.graph.LiveNode;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.ValueObjectId;

class NodeReuser {
    private final Map<GlobalId, LiveNode> reverseCdoIdMapForGlobalReuse = new HashMap<GlobalId, LiveNode>();
    private final List<LiveNode> nodes = new ArrayList<LiveNode>();
    private final Queue<LiveNode> stubs = new LinkedList<LiveNode>();
    private int reusedNodes;
    private int entities;
    private int valueObjects;

    NodeReuser() {
    }

    boolean isGraphLevelReusable(Cdo cdo) {
        return this.reverseCdoIdMapForGlobalReuse.containsKey(this.reverseCdoIdMapKey(cdo));
    }

    Optional<LiveNode> locallyReusableValueObjectNode(Cdo cdo, LiveNode parent) {
        return parent.findOnPathFromRoot(p -> ((LiveCdo)p.getCdo()).getWrappedCdo().equals(cdo.getWrappedCdo()), p -> !p.isValueObjectNode());
    }

    LiveNode getForReuse(Cdo cdo) {
        ++this.reusedNodes;
        return this.reverseCdoIdMapForGlobalReuse.get(this.reverseCdoIdMapKey(cdo));
    }

    List<LiveNode> nodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    void saveForReuse(LiveNode reference) {
        if (reference.getGlobalId() instanceof InstanceId) {
            ++this.entities;
        }
        if (reference.getGlobalId() instanceof ValueObjectId) {
            ++this.valueObjects;
        }
        if (reference.isEntityNode()) {
            this.reverseCdoIdMapForGlobalReuse.put(this.reverseCdoIdMapKey((Cdo)reference.getCdo()), reference);
        }
        this.nodes.add(reference);
    }

    void enqueueStub(LiveNode nodeStub) {
        this.stubs.offer(nodeStub);
    }

    LiveNode pollStub() {
        return this.stubs.poll();
    }

    boolean hasMoreStubs() {
        return !this.stubs.isEmpty();
    }

    int nodesCount() {
        return this.nodes.size();
    }

    int reusedNodesCount() {
        return this.reusedNodes;
    }

    int entitiesCount() {
        return this.entities;
    }

    int voCount() {
        return this.valueObjects;
    }

    private GlobalId reverseCdoIdMapKey(Cdo cdo) {
        return cdo.getGlobalId();
    }

    @Deprecated
    private static class SystemIdentityPlusOwnerIdWrapper {
        private final Object wrappedObject;
        private final GlobalId masterObjectId;

        SystemIdentityPlusOwnerIdWrapper(Cdo cdo) {
            this.wrappedObject = cdo.getWrappedCdo().get();
            this.masterObjectId = cdo.getGlobalId().masterObjectId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SystemIdentityPlusOwnerIdWrapper that = (SystemIdentityPlusOwnerIdWrapper)o;
            return Objects.equals(this.wrappedObject, that.wrappedObject) && Objects.equals(this.masterObjectId, that.masterObjectId);
        }

        public int hashCode() {
            return System.identityHashCode(this.wrappedObject) + this.masterObjectId.hashCode();
        }
    }
}

