/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.javers.common.string.ToStringBuilder;
import org.javers.core.commit.CommitId;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.repository.api.QueryParamsBuilder;

public class QueryParams {
    private final int limit;
    private final int skip;
    private final LocalDateTime from;
    private final Instant fromInstant;
    private final LocalDateTime to;
    private final Instant toInstant;
    private final CommitId toCommitId;
    private final Set<CommitId> commitIds;
    private final Long version;
    private final Long fromVersion;
    private final Long toVersion;
    private final String author;
    private final String authorLikeIgnoreCase;
    private final Map<String, Collection<String>> commitProperties;
    private final Map<String, String> commitPropertiesLike;
    private final boolean aggregate;
    private final Set<String> changedProperties;
    private final SnapshotType snapshotType;
    private final boolean loadCommitProps;
    private final Integer snapshotQueryLimit;

    QueryParams(int limit, int skip, LocalDateTime from, Instant fromInstant, LocalDateTime to, Instant toInstant, Set<CommitId> commitIds, Long version, Long fromVersion, Long toVersion, String author, String authorLikeIgnoreCase, Map<String, Collection<String>> commitProperties, Map<String, String> commitPropertiesLike, boolean aggregate, Set<String> changedProperties, CommitId toCommitId, SnapshotType snapshotType, boolean loadCommitProps, Integer snapshotQueryLimit) {
        this.snapshotQueryLimit = snapshotQueryLimit;
        this.limit = limit;
        this.skip = skip;
        this.from = from;
        this.fromInstant = fromInstant;
        this.to = to;
        this.toInstant = toInstant;
        this.commitIds = Collections.unmodifiableSet(commitIds);
        this.version = version;
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.author = author;
        this.authorLikeIgnoreCase = authorLikeIgnoreCase;
        this.commitProperties = Collections.unmodifiableMap(commitProperties);
        this.aggregate = aggregate;
        this.changedProperties = Collections.unmodifiableSet(changedProperties);
        this.commitPropertiesLike = Collections.unmodifiableMap(commitPropertiesLike);
        this.toCommitId = toCommitId;
        this.snapshotType = snapshotType;
        this.loadCommitProps = loadCommitProps;
    }

    public QueryParams changeAggregate(boolean newAggregate) {
        return QueryParamsBuilder.copy(this).withChildValueObjects(newAggregate).build();
    }

    public QueryParams nextPage() {
        return QueryParamsBuilder.copy(this).skip(this.skip + this.limit).build();
    }

    public int limit() {
        return this.limit;
    }

    public int skip() {
        return this.skip;
    }

    public boolean hasSnapshotQueryLimit() {
        return this.snapshotQueryLimit != null;
    }

    public Optional<Integer> snapshotQueryLimit() {
        return Optional.ofNullable(this.snapshotQueryLimit);
    }

    public Optional<LocalDateTime> from() {
        return Optional.ofNullable(this.from);
    }

    public Optional<Instant> fromInstant() {
        return Optional.ofNullable(this.fromInstant);
    }

    public Optional<LocalDateTime> to() {
        return Optional.ofNullable(this.to);
    }

    public Optional<Instant> toInstant() {
        return Optional.ofNullable(this.toInstant);
    }

    public Optional<CommitId> toCommitId() {
        return Optional.ofNullable(this.toCommitId);
    }

    public Set<CommitId> commitIds() {
        return Collections.unmodifiableSet(this.commitIds);
    }

    public Map<String, Collection<String>> commitProperties() {
        return this.commitProperties != null ? this.commitProperties : Collections.emptyMap();
    }

    public Map<String, String> commitPropertiesLike() {
        return this.commitPropertiesLike != null ? this.commitPropertiesLike : Collections.emptyMap();
    }

    public Set<String> changedProperties() {
        return Collections.unmodifiableSet(this.changedProperties);
    }

    public Optional<Long> version() {
        return Optional.ofNullable(this.version);
    }

    public Optional<Long> fromVersion() {
        return Optional.ofNullable(this.fromVersion);
    }

    public Optional<Long> toVersion() {
        return Optional.ofNullable(this.toVersion);
    }

    public Optional<String> author() {
        return Optional.ofNullable(this.author);
    }

    public Optional<String> authorLikeIgnoreCase() {
        return Optional.ofNullable(this.authorLikeIgnoreCase);
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public boolean isLoadCommitProps() {
        return this.loadCommitProps;
    }

    public Optional<SnapshotType> snapshotType() {
        return Optional.ofNullable(this.snapshotType);
    }

    public String toString() {
        return ToStringBuilder.toString(this, new Object[]{"aggregate", this.aggregate, "from", this.from, "fromInstant", this.fromInstant, "to", this.to, "toInstant", this.toInstant, "toCommitId", this.toCommitId, "commitIds", this.commitIds, "changeProperties", this.changedProperties, "version", this.version, "author", this.author, "snapshotType", this.snapshotType, "limit", this.limit, "skip", this.skip, "snapshotQueryLimit", this.snapshotQueryLimit});
    }
}

