/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.javers.common.collections.Lists;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;

public abstract class ClientsClassDefinitionBuilder<T extends ClientsClassDefinitionBuilder> {
    private Class<?> clazz;
    private List<String> ignoredProperties = Collections.emptyList();
    private List<String> includedProperties = Collections.emptyList();
    private List<String> shallowProperties = Collections.emptyList();
    private Optional<String> typeName = Optional.empty();

    ClientsClassDefinitionBuilder(Class<?> clazz) {
        this.clazz = clazz;
    }

    public T withIgnoredProperties(String ... ignoredProperties) {
        this.withIgnoredProperties(Lists.asList(ignoredProperties));
        return (T)this;
    }

    public T withIgnoredProperties(List<String> ignoredProperties) {
        Validate.argumentIsNotNull(ignoredProperties);
        if (this.includedProperties.size() > 0) {
            throw new JaversException(JaversExceptionCode.IGNORED_AND_INCLUDED_PROPERTIES_MIX, this.clazz.getSimpleName());
        }
        this.ignoredProperties = ignoredProperties;
        return (T)this;
    }

    public T withIncludedProperties(List<String> includedProperties) {
        Validate.argumentIsNotNull(includedProperties);
        if (this.ignoredProperties.size() > 0) {
            throw new JaversException(JaversExceptionCode.IGNORED_AND_INCLUDED_PROPERTIES_MIX, this.clazz.getSimpleName());
        }
        this.includedProperties = includedProperties;
        return (T)this;
    }

    public T withShallowProperties(List<String> shallowProperties) {
        Validate.argumentIsNotNull(shallowProperties);
        this.shallowProperties = shallowProperties;
        return (T)this;
    }

    public T withTypeName(Optional<String> typeName) {
        Validate.argumentIsNotNull(typeName);
        this.typeName = typeName;
        return (T)this;
    }

    public T withTypeName(String typeName) {
        return this.withTypeName(Optional.ofNullable(typeName));
    }

    public ClientsClassDefinition build() {
        throw new RuntimeException("not implemented");
    }

    Class<?> getClazz() {
        return this.clazz;
    }

    List<String> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    List<String> getIncludedProperties() {
        return this.includedProperties;
    }

    List<String> getShallowProperties() {
        return this.shallowProperties;
    }

    Optional<String> getTypeName() {
        return this.typeName;
    }
}

