/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.EnumerationAwareOwnerContext;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.TypeMapperLazy;

public class CollectionType
extends ContainerType {
    public CollectionType(Type baseJavaType, TypeMapperLazy typeMapperLazy) {
        super(baseJavaType, typeMapperLazy);
    }

    @Override
    public boolean isEmpty(Object collection) {
        return collection == null || ((Collection)collection).isEmpty();
    }

    @Override
    public Object map(Object sourceEnumerable, EnumerableFunction mapFunction, OwnerContext owner) {
        return this.mapToList(sourceEnumerable, mapFunction, owner);
    }

    protected Object mapToList(Object sourceEnumerable, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentsAreNotNull(mapFunction, owner);
        Collection sourceCol = CollectionType.wrapNull(sourceEnumerable);
        EnumerationAwareOwnerContext enumerationContext = new EnumerationAwareOwnerContext(owner, true);
        ArrayList targetList = new ArrayList();
        for (Object sourceVal : sourceCol) {
            targetList.add(mapFunction.apply(sourceVal, enumerationContext));
        }
        return Collections.unmodifiableList(targetList);
    }

    protected Object mapToSet(Object sourceEnumerable, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentsAreNotNull(mapFunction, owner);
        Collection sourceCol = CollectionType.wrapNull(sourceEnumerable);
        HashSet targetSet = new HashSet(sourceCol.size());
        EnumerationAwareOwnerContext enumerationContext = new EnumerationAwareOwnerContext(owner, true);
        for (Object sourceVal : sourceCol) {
            targetSet.add(mapFunction.apply(sourceVal, enumerationContext));
        }
        return Collections.unmodifiableSet(targetSet);
    }

    @Override
    public Object map(Object sourceEnumerable, Function mapFunction, boolean filterNulls) {
        Collection sourceCol = CollectionType.wrapNull(sourceEnumerable);
        return Collections.unmodifiableList(sourceCol.stream().map(sourceVal -> sourceVal == null ? null : mapFunction.apply(sourceVal)).filter(mappedVal -> !filterNulls || mappedVal != null).collect(Collectors.toList()));
    }

    @Override
    public Object empty() {
        return Collections.emptyList();
    }

    @Override
    protected Stream<Object> items(Object source) {
        return CollectionType.wrapNull(source).stream();
    }

    public static Collection wrapNull(Object col) {
        if (col == null) {
            return Collections.emptyList();
        }
        return (Collection)col;
    }

    @Override
    public Class<?> getEnumerableInterface() {
        return Collection.class;
    }
}

