/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.util;

import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.javers.common.collections.Lists;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.json.AbstractJsonTypeAdapter;
import org.javers.core.json.JsonAdvancedTypeAdapter;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.json.typeadapter.util.FileTypeAdapter;
import org.javers.core.json.typeadapter.util.JavaSqlDateTypeAdapter;
import org.javers.core.json.typeadapter.util.JavaSqlTimeTypeAdapter;
import org.javers.core.json.typeadapter.util.JavaSqlTimestampTypeAdapter;
import org.javers.core.json.typeadapter.util.JavaUtilDateTypeAdapter;
import org.javers.core.json.typeadapter.util.PathTypeAdapter;
import org.javers.core.json.typeadapter.util.UUIDTypeAdapter;
import org.javers.core.metamodel.type.ValueType;

public class UtilTypeCoreAdapters {
    private static final DateTimeFormatter ISO_INSTANT_FORMAT = DateTimeFormatter.ISO_INSTANT;
    private static final DateTimeFormatter ISO_LOCAL_TIME_FORMAT = DateTimeFormatter.ISO_LOCAL_TIME;
    private static final DateTimeFormatter ISO_LOCAL_FORMAT = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    private static final DateTimeFormatter ISO_ZONED_FORMAT = DateTimeFormatter.ISO_ZONED_DATE_TIME;

    public static LocalDateTime deserializeLocalDateTime(String date) {
        return LocalDateTime.parse(date, ISO_LOCAL_FORMAT);
    }

    public static LocalTime deserializeLocalTime(String date) {
        return LocalTime.parse(date, ISO_LOCAL_TIME_FORMAT);
    }

    public static ZonedDateTime deserializeToZonedDateTime(String date) {
        return ZonedDateTime.parse(date, ISO_ZONED_FORMAT);
    }

    public static Instant deserializeToInstant(String date) {
        return Instant.parse(date);
    }

    public static Date deserializeToUtilDate(String date) {
        LocalDateTime localDateTime = UtilTypeCoreAdapters.deserializeLocalDateTime(date);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String serialize(Instant sourceValue) {
        return ISO_INSTANT_FORMAT.format(sourceValue);
    }

    public static String serialize(LocalDateTime date) {
        return date.format(ISO_LOCAL_FORMAT);
    }

    public static String serialize(ZonedDateTime date) {
        return date.format(ISO_ZONED_FORMAT);
    }

    public static String serialize(LocalTime date) {
        return date.format(ISO_LOCAL_TIME_FORMAT);
    }

    public static String serialize(Date date) {
        return UtilTypeCoreAdapters.serialize(UtilTypeCoreAdapters.fromUtilDate(date));
    }

    public static LocalDateTime fromUtilDate(Date date) {
        if (date.getClass() == Date.class) {
            return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        return UtilTypeCoreAdapters.fromUtilDate(new Date(date.getTime()));
    }

    public static Date toUtilDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static List<AbstractJsonTypeAdapter> adapters() {
        return Lists.immutableListOf(new PathTypeAdapter(), new JavaUtilDateTypeAdapter(), new JavaSqlDateTypeAdapter(), new JavaSqlTimestampTypeAdapter(), new JavaSqlTimeTypeAdapter(), new FileTypeAdapter(), new UUIDTypeAdapter());
    }

    public static List<ValueType> valueTypes() {
        return UtilTypeCoreAdapters.adapters().stream().flatMap(it -> UtilTypeCoreAdapters.getValueTypes(it).stream()).map(c -> new ValueType((Type)c)).collect(Collectors.toList());
    }

    private static List<Class<?>> getValueTypes(AbstractJsonTypeAdapter adapter) {
        if (adapter instanceof JsonAdvancedTypeAdapter) {
            return List.of(((JsonAdvancedTypeAdapter)adapter).getTypeSuperclass());
        }
        if (adapter instanceof JsonTypeAdapter) {
            return ((JsonTypeAdapter)adapter).getValueTypes();
        }
        throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
    }
}

