/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.commit;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.javers.core.json.CdoSnapshotSerialized;
import org.javers.core.json.JsonConverter;
import org.javers.core.json.typeadapter.commit.CommitPropertiesConverter;

public class CdoSnapshotAssembler {
    private final JsonConverter jsonConverter;

    public CdoSnapshotAssembler(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    public JsonElement assemble(CdoSnapshotSerialized snapshot) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("commitMetadata", this.assembleCommitMetadata(snapshot));
        jsonObject.add("state", this.jsonConverter.fromJsonToJsonElement(snapshot.getSnapshotState()));
        jsonObject.add("changedProperties", this.assembleChangedPropNames(snapshot));
        jsonObject.addProperty("type", snapshot.getSnapshotType());
        jsonObject.addProperty("version", (Number)snapshot.getVersion());
        jsonObject.add("globalId", this.assembleGlobalId(snapshot));
        return jsonObject;
    }

    private JsonElement assembleGlobalId(CdoSnapshotSerialized snapshot) {
        String fragment = snapshot.getGlobalIdFragment();
        String localIdJSON = snapshot.getGlobalIdLocalId();
        String cdoType = snapshot.getGlobalIdTypeName();
        String ownerFragment = snapshot.getOwnerGlobalIdFragment();
        String ownerLocalId = snapshot.getOwnerGlobalIdLocalId();
        String ownerCdoType = snapshot.getOwnerGlobalIdTypeName();
        JsonObject json = this.assembleOneGlobalId(cdoType, localIdJSON, fragment);
        if (ownerFragment != null || ownerLocalId != null || ownerCdoType != null) {
            JsonObject ownerId = this.assembleOneGlobalId(ownerCdoType, ownerLocalId, ownerFragment);
            json.add("ownerId", (JsonElement)ownerId);
        }
        return json;
    }

    private JsonObject assembleOneGlobalId(String typeName, String localIdJson, String fragment) {
        JsonObject json = new JsonObject();
        if (localIdJson != null) {
            json.addProperty("entity", typeName);
            json.add("cdoId", this.jsonConverter.fromJsonToJsonElement(localIdJson));
        } else {
            json.addProperty("valueObject", typeName);
            json.addProperty("fragment", fragment);
        }
        return json;
    }

    private JsonElement assembleChangedPropNames(CdoSnapshotSerialized snapshot) {
        String changed = snapshot.getChangedProperties();
        if (changed == null || changed.isEmpty()) {
            return new JsonObject();
        }
        return this.jsonConverter.fromJsonToJsonElement(changed);
    }

    private JsonElement assembleCommitMetadata(CdoSnapshotSerialized snapshot) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("author", snapshot.getCommitAuthor());
        jsonObject.add("properties", CommitPropertiesConverter.toJson(snapshot.getCommitProperties()));
        jsonObject.add("commitDate", this.jsonConverter.toJsonElement(snapshot.getCommitDate()));
        jsonObject.add("commitDateInstant", this.jsonConverter.toJsonElement(snapshot.getCommitDateInstant()));
        jsonObject.add("id", this.jsonConverter.toJsonElement(snapshot.getCommitId()));
        return jsonObject;
    }
}

