/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.collections;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.ZoneId;
import java.time.zone.ZoneRules;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.javers.common.collections.Lists;
import org.javers.common.reflection.ReflectionUtil;

public class WellKnownValueTypes {
    private static final List<Class<?>> VALUE_TYPES = Lists.asList(BigDecimal.class, BigInteger.class, ThreadLocal.class, UUID.class, Currency.class, URI.class, URL.class, CharSequence.class, String.class, Number.class, Locale.class, TimeZone.class, ZoneRules.class, ZoneId.class);

    public static List<Class<?>> getOldGoodValueTypes() {
        return Collections.unmodifiableList(VALUE_TYPES);
    }

    public static boolean isOldGoodValueType(Object object) {
        if (object == null) {
            return false;
        }
        return WellKnownValueTypes.isOldGoodValueType(object.getClass());
    }

    private static boolean isOldGoodValueType(Class clazz) {
        return ReflectionUtil.isAssignableFromAny(clazz, VALUE_TYPES);
    }
}

