/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.Optional;
import java.util.Set;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.CommitIdGenerator;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.jql.AnyDomainObjectFilter;
import org.javers.repository.jql.ClassFilter;
import org.javers.repository.jql.Filter;
import org.javers.repository.jql.FilterDefinition;
import org.javers.repository.jql.IdFilter;
import org.javers.repository.jql.ShadowQueryRunner;
import org.javers.repository.jql.ShadowScope;
import org.javers.repository.jql.ShadowScopeDefinition;
import org.javers.repository.jql.ShadowStreamQueryRunner;
import org.javers.repository.jql.VoOwnerFilter;

public class JqlQuery {
    public static final String JQL_LOGGER_NAME = "org.javers.JQL";
    private QueryParams queryParams;
    private final FilterDefinition filterDefinition;
    private final ShadowScopeDefinition shadowScopeDef;
    private Filter filter;
    private ShadowStreamQueryRunner.ShadowStreamStats shadowStats;

    JqlQuery(FilterDefinition filter, QueryParams queryParams, ShadowScopeDefinition shadowScope) {
        Validate.argumentsAreNotNull(filter);
        this.queryParams = queryParams;
        this.filterDefinition = filter;
        this.shadowScopeDef = shadowScope;
    }

    JqlQuery nextQueryForStream() {
        return new JqlQuery(this.filterDefinition, this.queryParams.nextPage(), this.shadowScopeDef);
    }

    void validate(CommitIdGenerator commitIdGenerator) {
        if (this.queryParams.toCommitId().isPresent() && commitIdGenerator != CommitIdGenerator.SYNCHRONIZED_SEQUENCE) {
            throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "toCommitId() filter can be used only with CommitIdGenerator.SYNCHRONIZED_SEQUENCE");
        }
        if (this.isAggregate() && !this.isClassQuery() && !this.isInstanceIdQuery()) {
            throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "aggregate filter can be enabled only when querying for Entities, in byClass() and byInstanceId() queries");
        }
        if (this.getShadowScope() != ShadowScope.DEEP_PLUS && this.getMaxGapsToFill() > 0) {
            throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "maxGapsToFill can be used only in the DEEP_PLUS query scope");
        }
    }

    public String toString() {
        return "JqlQuery {\n  " + String.valueOf(this.filterDefinition) + "\n  " + String.valueOf(this.queryParams) + "\n  shadowScope: " + String.valueOf((Object)this.shadowScopeDef.getScope()) + "\n" + this.streamStats().map(it -> "  " + String.valueOf(it) + "\n").orElse("") + "}";
    }

    FilterDefinition getFilterDefinition() {
        return this.filterDefinition;
    }

    QueryParams getQueryParams() {
        return this.queryParams;
    }

    boolean hasFilter(Class<? extends Filter> ofType) {
        return this.getFilter(ofType).isPresent();
    }

    Set<ManagedType> getClassFilter() {
        return this.getFilter(ClassFilter.class).get().getManagedTypes();
    }

    GlobalId getIdFilter() {
        return this.getFilter(IdFilter.class).get().getGlobalId();
    }

    VoOwnerFilter getVoOwnerFilter() {
        return this.getFilter(VoOwnerFilter.class).get();
    }

    <T extends Filter> Optional<T> getFilter(Class<T> ofType) {
        Validate.conditionFulfilled(this.filter != null, "jqlQuery is not compiled");
        if (this.filter.getClass().equals(ofType)) {
            return Optional.of(this.filter);
        }
        return Optional.empty();
    }

    JqlQuery changeLimit(int newLimit, int newSkip) {
        return new JqlQuery(this.filterDefinition, QueryParamsBuilder.copy(this.queryParams).limit(newLimit).skip(newSkip).build(), this.shadowScopeDef);
    }

    void changeToAggregatedIfEntityQuery() {
        if (this.isInstanceIdQuery() || this.isClassQuery()) {
            this.queryParams = this.queryParams.changeAggregate(true);
        }
    }

    void compile(GlobalIdFactory globalIdFactory, TypeMapper typeMapper, CommitIdGenerator commitIdGenerator) {
        this.filter = this.filterDefinition.compile(globalIdFactory, typeMapper);
        this.validate(commitIdGenerator);
    }

    boolean matches(GlobalId globalId) {
        return this.filter.matches(globalId);
    }

    boolean isAnyDomainObjectQuery() {
        return this.hasFilter(AnyDomainObjectFilter.class);
    }

    boolean isIdQuery() {
        return this.hasFilter(IdFilter.class);
    }

    boolean isClassQuery() {
        return this.hasFilter(ClassFilter.class);
    }

    boolean isInstanceIdQuery() {
        Optional<IdFilter> idFilter = this.getFilter(IdFilter.class);
        return idFilter.isPresent() && idFilter.get().isInstanceIdFilter();
    }

    boolean isVoOwnerQuery() {
        return this.hasFilter(VoOwnerFilter.class);
    }

    public boolean isAggregate() {
        return this.queryParams.isAggregate();
    }

    public int getMaxGapsToFill() {
        return this.shadowScopeDef.getMaxGapsToFill();
    }

    public ShadowScope getShadowScope() {
        return this.shadowScopeDef.getScope();
    }

    public Optional<ShadowStreamQueryRunner.ShadowStreamStats> streamStats() {
        return Optional.ofNullable(this.shadowStats);
    }

    public Optional<ShadowQueryRunner.ShadowStats> firstFrameStats() {
        return this.streamStats().map(it -> it.getFirstFrameStats());
    }

    void setShadowQueryRunnerStats(ShadowStreamQueryRunner.ShadowStreamStats stats) {
        this.shadowStats = stats;
    }
}

