/*
 * Decompiled with CFR 0.152.
 */
package org.javers.java8support;

import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.core.diff.custom.CustomValueComparator;
import org.javers.core.diff.custom.CustomValueToStringTemplate;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.metamodel.type.ValueType;
import org.javers.java8support.DurationTypeAdapter;
import org.javers.java8support.InstantTypeAdapter;
import org.javers.java8support.LocalDateTimeTypeAdapter;
import org.javers.java8support.LocalDateTypeAdapter;
import org.javers.java8support.LocalTimeTypeAdapter;
import org.javers.java8support.MonthDayTypeAdapter;
import org.javers.java8support.OffsetDateTimeTypeAdapter;
import org.javers.java8support.OffsetTimeTypeAdapter;
import org.javers.java8support.PeriodTypeAdapter;
import org.javers.java8support.YearMonthTypeAdapter;
import org.javers.java8support.YearTypeAdapter;
import org.javers.java8support.ZoneOffsetTypeAdapter;
import org.javers.java8support.ZonedDateTimeTypeAdapter;

public class Java8TypeAdapters {
    public static List<JsonTypeAdapter> adapters() {
        return Lists.immutableListOf(new LocalDateTypeAdapter(), new LocalDateTimeTypeAdapter(), new LocalTimeTypeAdapter(), new YearTypeAdapter(), new ZonedDateTimeTypeAdapter(), new ZoneOffsetTypeAdapter(), new OffsetDateTimeTypeAdapter(), new InstantTypeAdapter(), new PeriodTypeAdapter(), new DurationTypeAdapter(), new YearMonthTypeAdapter(), new MonthDayTypeAdapter(), new OffsetTimeTypeAdapter());
    }

    public static List<ValueType> valueTypes() {
        return Lists.immutableListOf(Java8TypeAdapters.buildValueType(LocalDate.class, v -> v.getYear() + "," + v.getMonthValue() + "," + v.getDayOfMonth()), Java8TypeAdapters.buildValueType(LocalDateTime.class, v -> v.toString().replace("T", ",")), Java8TypeAdapters.buildValueType(LocalTime.class, v -> v.getHour() + "," + v.getMinute() + "," + v.getSecond() + "," + v.getNano()), Java8TypeAdapters.buildValueType(Year.class, v -> v.toString()), Java8TypeAdapters.buildValueType(ZonedDateTime.class, v -> v.toLocalDateTime().toString() + "," + String.valueOf(v.getOffset()) + "," + v.getZone().getId()), Java8TypeAdapters.buildValueType(ZoneOffset.class, v -> "" + v.getTotalSeconds()), Java8TypeAdapters.buildValueType(OffsetDateTime.class, v -> v.toLocalDateTime().toString() + "," + String.valueOf(v.getOffset())), Java8TypeAdapters.buildValueType(Instant.class, v -> v.getEpochSecond() + "," + v.getNano()), Java8TypeAdapters.buildValueType(Period.class, v -> v.getYears() + "," + v.getMonths() + "," + v.getDays()), Java8TypeAdapters.buildValueType(Duration.class, v -> v.getSeconds() + "," + v.getNano()), Java8TypeAdapters.buildValueType(YearMonth.class, v -> v.toString()), Java8TypeAdapters.buildValueType(MonthDay.class, v -> v.toString()), Java8TypeAdapters.buildValueType(OffsetTime.class, v -> v.toLocalTime().toString() + "," + String.valueOf(v.getOffset())));
    }

    static <T> ValueType buildValueType(Class<T> clazz, CustomValueToStringTemplate<T> toString) {
        return new ValueType((Type)clazz, (CustomValueComparator)toString);
    }
}

