/*
 * Decompiled with CFR 0.152.
 */
package org.javers.guava;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.json.JsonAdvancedTypeAdapter;

class MultimapTypeAdapter
implements JsonAdvancedTypeAdapter<Multimap> {
    MultimapTypeAdapter() {
    }

    @Override
    public Multimap fromJson(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        JsonArray jsonArray = (JsonArray)json;
        List<Type> mapTypeArguments = ReflectionUtil.getAllTypeArguments(typeOfT);
        Validate.conditionFulfilled(mapTypeArguments.size() == 2, "expected exactly two type parameters in Multimap " + String.valueOf(typeOfT));
        ArrayListMultimap multimap = ArrayListMultimap.create();
        jsonArray.forEach(arg_0 -> MultimapTypeAdapter.lambda$fromJson$0(context, mapTypeArguments, (Multimap)multimap, arg_0));
        return multimap;
    }

    @Override
    public JsonElement toJson(Multimap sourceValue, Type typeOfT, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        sourceValue.entries().forEach(e -> {
            JsonObject entry = new JsonObject();
            entry.add("key", context.serialize(((Map.Entry)e).getKey()));
            entry.add("value", context.serialize(((Map.Entry)e).getValue()));
            jsonArray.add((JsonElement)entry);
        });
        return jsonArray;
    }

    @Override
    public Class getTypeSuperclass() {
        return Multimap.class;
    }

    private static /* synthetic */ void lambda$fromJson$0(JsonDeserializationContext context, List mapTypeArguments, Multimap multimap, JsonElement e) {
        JsonObject entry = e.getAsJsonObject();
        Object key = context.deserialize(entry.get("key"), (Type)mapTypeArguments.get(0));
        Object value = context.deserialize(entry.get("value"), (Type)mapTypeArguments.get(1));
        multimap.put(key, value);
    }
}

